<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AccountsPermissions extends Model
{
    protected $fillable = [
        'role_id',
        'account_id',
        'account_type', // Added for differentiation (MainAccount, ControlAccount, etc.)
        'account_name', // Stores the account name
        'main_account_id',
        'control_account_id',
        'sub_control_account_id',
        'transaction_account_id'
    ];

    protected $table = 'accounts_permissions';

    /**
     * Relationship with Role model
     */
    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    /**
     * Method to fetch MainAccounts with nested related accounts
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function getNestedAccounts()
    {
        return MainAccount::with([
            'controlAccounts.subControlAccounts.transactionAccounts'
        ])->get();
    }
}
