<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductsSubCategoryParent extends Model
{
    protected $table = 'products_sub_cat_parent';
    protected $primaryKey = 'id_pro_sub_cat_parent';
    protected $fillable = [
        'pro_cate_main_id',
        'name',
        'name_urdu',
        'status',
        'created_by',
    ];

    // A parent sub-category belongs to a main category
    public function mainCategory()
    {
        return $this->belongsTo(ProductsCategoryMain::class, 'pro_cate_main_id', 'id_pro_cate_main');
    }

    // A parent sub-category has many child sub-categories
    public function subCategoriesChild()
    {
        return $this->hasMany(ProductsSubCategoryChild::class, 'pro_sub_cat_parent_id', 'id_pro_sub_cat_parent');
    }
}
