<?php

namespace App;

use App\Suppliers;
//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
//    use HasFactory;

    // Define the table associated with the model
    protected $table = 'purchase_orders';

    // Define the primary key
    protected $primaryKey = 'id';

    // Define the fillable attributes
    protected $fillable = [
        'business_id', 'po_number', 'supplier_id', 'order_date', 'expected_delivery_date',
        'total_amount', 'custom_charges','tax','labour_charges','local_charges','weight_charges','grand_total','currency', 'status', 'notes','created_by'
    ];

    /**
     * Relationship: A Purchase Order belongs to a Supplier
     */
    public function supplier()
    {
        return $this->belongsTo(Suppliers::class, 'supplier_id', 'id_supplier');
    }
    public function createdBy()
    {
        return $this->belongsTo(User::class,  'created_by');
    }

    /**
     * Relationship: A Purchase Order has many Purchase Order Details
     */
    public function Purchasedetails()
    {
        return $this->hasMany(PurchaseOrderDetails::class, 'purchase_order_id', 'id');
    }
}
