@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Cities</span>
        <span>Edit City</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Edit City
        <span>
            <a href="{{ url('cities') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to List
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit City</h5>
                <form id="myForm" method="post" action="{{ url('city/update/' . Crypt::encrypt($city->id_city)) }}">
                    @csrf
                    @method('put')
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">City Name (English)</label>
                                <input type="text" name="city_name" class="form-control" required
                                    value="{{ $city->city_name }}" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">City Name (Urdu)</label>
                                <input type="text" name="city_name_urdu" class="form-control"
                                    value="{{ $city->city_name_urdu }}" />
                            </div>
                        </div>
                    </div>
                    <a href="{{ url('cities') }}" class="btn btn-danger pd-x-20">Cancel</a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Update</button>
                </form>

            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();

                document.getElementById('myForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });
    </script>
@endpush
