@extends('layouts.master')

<style>
    .step1 {
        background-color: #0283cc;
    }

    .step2 {
        background-color: #2ecc71;
    }

    .step3 {
        background-color: #e74a25;
    }

    .step4 {
        background-color: #ffb136;
    }

    .step1 .step2 .step3 .step4 {
        padding: 30px;
    }

    .icon-cart {
        float: right;
        font-size: 30px;
        margin-top: 15px;
        color: #fff;
    }

    .cart-para {
        font-size: 45px;
        color: #fff;
    }

    .span-change {
        padding: 10px;
    }
</style>

@section('content')
    <div class="az-content-breadcrumb">
        <span>Customer's Summary</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Customer's Summary
        <span>
            <a href="{{ url('customers') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i> Back to Customers
            </a>
        </span>
    </h2>
    <div class="row my-3">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="profile-card bg-light shadow rounded p-2">
                <section id="personal-info">
                    <div class="mt-3" style="background-color: #00beda">
                        <h4 class="p-4 text-light"><strong>Customer Information</strong></h4>
                    </div>
                    <div class="px-5 mt-3">
                        <div class="mb-3 d-flex align-items-center">
                            <h5>
                                <label class="fw-bold text-muted me-2">Name:</label>
                                <span><strong>{{ $view->customer_name }}</strong></span>
                            </h5>
                        </div>
                        <div class="mb-3 d-flex align-items-center">
                            <h5>
                                <label class="fw-bold text-muted me-2">Address:</label>
                                <strong>{{ $view->customer_address }}</strong>
                            </h5>
                        </div>
                        <div class="mb-3 d-flex align-items-center">
                            <h5>
                                <label class="fw-bold text-muted me-2">Phone:</label>
                                <strong>{{ $view->customer_cell }}</strong>
                            </h5>
                        </div>
                        <div class="mb-3 d-flex align-items-center">
                            <h5>
                                <label class="fw-bold text-muted me-2">Email:</label>
                                <strong>{{ $view->customer_email }}</strong>
                            </h5>
                        </div>
                    </div>

                    <hr>
                    <div class="row span-change">
                        <div class="col-lg-3 col-md-3 col-12">
                            <div class="step1 p-3">
                                <p class="cart-para">
                                    0
                                    <span class="icon-cart"><i class="fa-solid fa-cart-shopping"></i></span>
                                </p>
                                <h3 class="text-light">Total Sale Orders</h3>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-12">
                            <div class="step2 p-3">
                                <p class="cart-para">
                                    0
                                    <span class="icon-cart"><i class="fa-solid fa-truck"></i></span>
                                </p>
                                <h3 class="text-light">Total Delivered Orders</h3>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-12">
                            <div class="step3 p-3">
                                <p class="cart-para">
                                    0
                                    <span class="icon-cart"><i class="fa-solid fa-xmark"></i></span>
                                </p>
                                <h3 class="text-light">Cancelled Orders</h3>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-12">
                            <div class="step4 p-3">
                                <p class="cart-para">
                                    0
                                    <span class="icon-cart"><i class="fa-regular fa-clock"></i></span>
                                </p>
                                <h3 class="text-light">Total Pending Orders</h3>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h6 class="az-content-title" style="display: inline">
                    Account Information
                    <span>
                        <a href="javascript:void(0)" class="btn btn-az-primary" style="float: right"><i
                                class="fa-solid fa-plus"></i> Add Voucher
                        </a>
                    </span>
                </h6>
                <div>
                    <table id="example2" class="table table-responsive table-borderless border-0 table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">Account Name</th>
                                <th class="wd-10p">Account #</th>
                                <th class="wd-10p">Debit</th>
                                <th class="wd-10p">Credit</th>
                                <th class="wd-10p">Balance</th>
                                <th class="wd-10p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Receivables From Customer</td>
                                <td>01-002-009-0174</td>
                                <td>
                                    <span class="btn btn-danger rounded shadow-base text-light">203100.00</span>
                                </td>
                                <td>
                                    <span class="btn btn-info rounded shadow-base text-light">0.00</span>
                                </td>
                                <td>
                                    <span class="btn btn-warning rounded shadow-base text-dark">203100</span>
                                </td>
                                <td>
                                    <a class="btn btn-success rounded shadow-base text-light" title="View Detail"
                                        href="#">
                                        <i class="fa-solid fa-info"></i>
                                        <span> View Detail</span>
                                    </a>
                                    <a class="btn btn-success rounded shadow-base text-light" title="Email"
                                        href="#">
                                        <i class="fa-solid fa-envelope text-light"></i>
                                        <span> Email</span>
                                    </a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-5">
        {{-- Table 1 --}}
        <div class="col-md-6 col-lg-6 col-xl-6 col-12">
            <div class="card card-body pd-40">
                <h6 class="az-content-title" style="display: inline">
                    Sale Orders History
                    <span>
                        <a href="javascript:void(0)" class="btn btn-az-primary" style="float: right"><i
                                class="fa-solid fa-plus"></i> Create Sale
                        </a>
                    </span>
                </h6>
                <hr>
                <div>
                    <table id="example22" class="table table-responsive table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">ID</th>
                                <th class="wd-10p">Order #</th>
                                <th class="wd-10p">Order Date</th>
                                <th class="wd-10p">Qty</th>
                                <th class="wd-10p">Amount</th>
                                <th class="wd-10p">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        {{-- Table 2 --}}
        <div class="col-md-6 col-lg-6 col-xl-6 col-12">
            <div class="card card-body pd-40">
                <h6 class="az-content-title" style="display: inline">
                    Payment History
                    <span>
                        <a href="javascript:void(0)" class="btn btn-az-primary" style="float: right"><i
                                class="fa-solid fa-plus"></i> Add Payment
                        </a>
                    </span>
                </h6>
                <hr>
                <div>
                    <table id="example222" class="table table-responsive table-borderless border-0 table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">Invoice #</th>
                                <th class="wd-10p">Invoice Date</th>
                                <th class="wd-5p">Amount</th>
                                <th class="wd-5p">Status</th>
                                <th class="wd-15p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Inv-2024-07-00001</td>
                                <td>01-01-1970</td>
                                <td>600.00</td>
                                <td>Unpaid</td>
                                <td>
                                    <a class="btn btn-warning rounded shadow-base text-light" title="View"
                                        href="#">
                                        <i class="fa-solid fa-eye"></i>
                                    </a>
                                    <a class="btn btn-danger rounded shadow-base text-light" title="Mark as Paid"
                                        href="#">
                                        <i class="fa-solid fa-check"></i>
                                    </a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            // Table 1
            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: true,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });

            // Table 2
            $('#example22 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });

            $('#example22').DataTable({

                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: true,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });

            // Table 3
            $('#example222 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });
            $('#example222').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: true,
                columnDefs: [{
                    className: 'control',
                    orderable: false
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;
                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });
    </script>
@endpush
