@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Designations</span>
        <span>Edit Designation</span>
    </div>

    <h2 class="az-content-title">Edit Designation</h2>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('designations.update', \Crypt::encrypt($designation->id)) }}" method="POST">
                @csrf
                @method('POST')
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="title" class="form-label">Designation Title <span class="text-danger">*</span></label>
                        <input type="text" name="title" id="title" class="form-control"
                            value="{{ $designation->title }}" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="department_id" class="form-label">Department</label>

                        <select name="department_id" id="department_id" class="form-control">
                            <option value="">Select Department</option>
                            @foreach ($departments as $dept)
                                <option value="{{ $dept->id }}"
                                    {{ $designation->department_id == $dept->id ? 'selected' : '' }}>
                                    {{ $dept->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="status" class="form-label">Status</label>
                        <select name="status" id="status" class="form-control">
                            <option value="active" {{ $designation->status == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ $designation->status == 'inactive' ? 'selected' : '' }}>Inactive
                            </option>
                        </select>
                    </div>
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-primary">Update</button>
                    <a href="{{ route('designations.index') }}" class="btn btn-light">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection
