@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Goods Receipts</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Goods Receipts List
        <span>
            @can('Goods Receipts add')
                <a id="addbtn" href="{{ route('good_receipts.create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Add Goods Receipts
                </a>
            @endcan
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped">
                        <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-20p">Date</th>
                                <th class="wd-10p">Vehicle</th>
                                <th class="wd-10p">Bilty No</th>
                                <th class="wd-10p">Total Bori</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="none">Item Details</th>
                                <th class="wd-10p">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($good_receipts_truck as $truck)
                                @foreach ($truck->goodReceipts as $key => $receipt)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $receipt->date }}</td>
                                        <td>{{ $truck->truck_no }}</td>
                                        <td>{{ $receipt->builty_no }}</td>
                                        <td>{{ number_format($receipt->goodReceiptDetails->sum('bori'), 2) }}</td>
                                        <td>{{ $receipt->supplier->supplier_name ?? null }}</td>
                                        <td>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th>Product Main Category</th>
                                                    <th>Product Parent Category</th>
                                                    <th>Product Child Category</th>
                                                    <th>Marka</th>
                                                    <th>Bori</th>
                                                    <th>Weight</th>
                                                    {{-- <th>Rate</th>
                                                    <th>Amount</th> --}}
                                                    <th>Remarks</th>
                                                </tr>
                                                @foreach ($receipt->goodReceiptDetails as $detail)
                                                    <tr>
                                                        <td>
                                                            {{ $detail->productMainCate->products_category_name ?? null }}
                                                        </td>
                                                        <td>
                                                            {{ $detail->productParentCate->name ?? null }}
                                                        </td>
                                                        <td>
                                                            {{ $detail->productChildCate->name ?? null }}
                                                        </td>
                                                        <td>{{ $detail->marka }}</td>
                                                        <td>{{ number_format($detail->bori, 2) }}</td>
                                                        <td>{{ number_format($detail->weight, 2) }}</td>
                                                        {{-- <td>{{ $detail->rate }}</td>
                                                        <td>{{ $detail->amount }}</td> --}}
                                                        <td>{{ $detail->remarks }}</td>
                                                    </tr>
                                                @endforeach
                                            </table>
                                        </td>

                                        <td>{{ $receipt->createdBy?->name }}</td>
                                        <td>
                                            @can('Goods Receipts edit')
                                                <a class="btn rounded shadow-base" title="Edit Goods"
                                                    href="{{ route('good_receipts.edit', Crypt::encrypt($receipt->id_good_rec)) }}">
                                                    <i class="text-primary fa-regular fa-pen-to-square"></i>
                                                    <span class="text-primary">Edit</span>
                                                </a>
                                            @endcan
                                            @can('Goods Receipts delete')
                                                <a class="btn rounded shadow-base" title="Delete Goods" data-toggle="modal"
                                                    data-target="#deleteModal"
                                                    data-id="{{ Crypt::encrypt($receipt->id_good_rec) }}">
                                                    <i class="text-danger fa-solid fa-trash-can"></i>
                                                    <span class="text-danger">Remove</span>
                                                </a>
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-20p">Date</th>
                                <th class="wd-10p">Vehicle</th>
                                <th class="wd-10p">Bilty No</th>
                                <th class="wd-10p">Total Bori</th>
                                <th class="wd-10p">Supplier</th>
                                <th class="none">Item Details</th>
                                <th class="wd-10p">Created By</th>
                                <th class="none">Action</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Goods Receipt?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('GET')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        document.addEventListener('keydown', function(event) {
            // Check if CTRL + A (or CMD + A) is pressed
            if ((event.ctrlKey || event.metaKey) && event.key.toLowerCase() === 'a') {
                event.preventDefault(); // Prevent default "Select All" behavior

                // Trigger the click event on the "Add Goods Receipts" button
                document.getElementById('addbtn').click();
            }
        });


        $(function() {
            oTable = $('#example2').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        text: 'CSV',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'excel',
                        text: 'Excel',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'pdf',
                        text: 'PDF',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    },
                    {
                        extend: 'print',
                        text: 'Print',
                        title: 'Goods Receipts List',
                        className: 'btn btn-default',
                        exportOptions: {
                            columns: 'th:not(:last-child)'
                        }
                    }
                ],
                responsive: !0
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('good_receipts/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
