@extends('layouts.master')
@section('content')
<style>
    .voucher-summary {
        background-color: #ffffff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        padding: 25px 30px;
        margin-bottom: 30px;
        border-left: 4px solid #28a745;
    }

    .voucher-summary h5 {
        font-size: 15px;
        color: #343a40;
        margin-bottom: 12px;
    }

    .voucher-summary h5 strong {
        color: #6c757d;
        font-weight: 600;
        margin-right: 4px;
    }

    .voucher-summary .badge {
        color: #fff;
        font-size: 12px;
        padding: 5px 10px;
        border-radius: 20px;
        margin-top: 5px;
    }

    .voucher-summary .meta-column {
        padding-left: 30px;
        border-left: 1px dashed #dee2e6;
    }

    @media (max-width: 768px) {
        .voucher-summary .meta-column {
            padding-left: 0;
            border-left: none;
            margin-top: 20px;
        }
    }
</style>
    <div class="az-content-breadcrumb no-print">
        <span>View {{ $voucherDetails->voucher_type }}</span>
    </div>
    <h2 class="az-content-title no-print" style="display: inline">
        <span class="no-print">View</span> {{ $voucherDetails->voucher_type }}
        <span class="no-print">
            <a href="{{ route('payment.list') }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i>
                Back to {{ $voucherDetails->voucher_type }} List
            </a>
        </span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div class="clearfix"></div>
                <div class="row voucher-summary">
                    <div class="col-md-6">
                        <div>
                            @php
                            $items = json_decode($vou_other_detail->adaegi_array ?? '[]', true);
                            $ids = collect($items)->pluck('adaegi_khata')->filter()->unique()->toArray();
                            $suppliers = \App\Suppliers::whereIn('id_supplier', $ids)
                                ->pluck('supplier_name', 'id_supplier');
                        @endphp

                        @if(count($ids))
                            <h5><strong>Supplierss:</strong>
                                @foreach ($ids as $id)
                                    <span class="badge badge-secondary me-1">{{ $suppliers[$id] ?? 'ID#' . $id }}</span>
                                @endforeach
                            </h5>
                        @endif
                            <h5><strong>Details:</strong> {{ $vou_other_detail->voucher_details ?? 'N/A' }}</h5>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div style="float: inline-end">
                            <h5><strong>Voucher Number:</strong> <br>{{ $voucherDetails->voucher_number }}</h5>
                            <h5><strong>Voucher Date:</strong>
                                <br>{{ \Carbon\Carbon::parse($voucherDetails->created_at)->format('d-m-Y') }}
                            </h5>
                            <h5><strong>Payment Mode:</strong> {{ ucfirst($vou_other_detail->payment_mode ?? 'N/A') }}</h5>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="mt-5">
                    @php
                        $showChequeDetails = $accountVouchers->contains(function ($voucher) {
                            return $voucher->voucher_chqno || $voucher->voucher_chqdate || $voucher->voucher_depdate || $voucher->voucher_depslipno;
                        });
                    @endphp

                    @if ($showChequeDetails)
                        <h4>Cheque Details</h4>
                        <table class="table table-hover table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Cheque No</th>
                                    <th>Cheque Date</th>
                                    <th>Deposit Date</th>
                                    <th>Deposit Slip No</th>
                                 
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($accountVouchers as $voucher)
                                    @if ($voucher->voucher_chqno || $voucher->voucher_chqdate || $voucher->voucher_depdate || $voucher->voucher_depslipno)
                                        <tr>
                                            <td>{{ $voucher->voucher_chqno ?? 'N/A' }}</td>
                                            <td>{{ $voucher->voucher_chqdate ? \Carbon\Carbon::parse($voucher->voucher_chqdate)->format('d-m-Y') : 'N/A' }}</td>
                                            <td>{{ $voucher->voucher_depdate ? \Carbon\Carbon::parse($voucher->voucher_depdate)->format('d-m-Y') : 'N/A' }}</td>
                                            <td>{{ $voucher->voucher_depslipno ?? 'N/A' }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            </tbody>
                        </table>
                    @else
                        <h4>Account Details</h4>
                        <table id="transactiontable" class="table table-hover table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Payment Mode</th>
                                    <th>Net Amount</th>
                                    <th>Transaction Type</th>
                                    <th>Cheque Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($accountVouchers as $voucher)
                                    <tr>
                                        <td>{{ ucfirst($voucher->payment_mode) }}</td>
                                        <td>{{ number_format($voucher->net_amount, 2) }}</td>
                                        <td>{{ $voucher->transaction_type }}</td>
                                        <td>{{ $voucher->cheq_status ?? 'N/A' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    @endif

                    <h4 class="mt-4">Voucher Details</h4>
                   @php
                    $items = json_decode($vou_other_detail->adaegi_array ?? '[]', true);
                    $totalAmount = 0;
                    $supplierIds = collect($items)->pluck('adaegi_khata')->filter()->unique()->toArray();
                    $supplierNames = \App\Suppliers::whereIn('id_supplier', $supplierIds)->pluck('supplier_name', 'id_supplier');
                @endphp

                    @if (count($items) > 0)
                        <table class="table table-hover table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>جمع کھاتہ</th>
                                    <th>رقم Debit</th>
                                    <th>Employee</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach ($items as $item)
                                <tr>
                                    <td>{{ $supplierNames[$item['adaegi_khata']] ?? 'ID#' . $item['adaegi_khata'] }}</td>
                                    <td>{{ number_format($item['credit_amount'] ?? 0, 2) }}</td>
                                    <td>{{ $item['employee'] ?? '' }}</td>
                                </tr>
                                @php $totalAmount += $item['credit_amount'] ?? 0; @endphp
                            @endforeach
                        </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="1" class="text-right">Total</th>
                                    <th>{{ number_format($totalAmount, 2) }}</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    @else
                        <div class="alert alert-info">No items recorded for this voucher</div>
                    @endif

                    <div class="no-print mt-4">
                        <a class="btn rounded shadow-base" title="Print Payment Voucher" onclick="window.print()">
                            <i class="text-success fa-solid fa-print"></i>
                            <span class="text-success">Print</span>
                        </a>
                        <a class="btn rounded shadow-base" title="Edit Payment Voucher"
                            href="{{ route('payment_voucher.edit', Crypt::encrypt($vou_other_detail->id_vouchers)) }}">
                            <i class="text-primary fa-solid fa-edit"></i>
                            <span class="text-primary">Edit</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this voucher?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            // Initialize DataTable if needed
            $('#transactiontable').DataTable({
                responsive: true,
                paging: false,
                searching: false,
                info: false
            });
        });
    </script>
@endpush
