@extends('layouts.master')
<style>
    .switch {
  position: relative;
  display: inline-block;
  width: 34px;
  height: 20px;
}

.switch input {
  display: none;
}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  transition: 0.4s;
  border-radius: 20px;
}

.slider:before {
  position: absolute;
  content: "";
  height: 14px;
  width: 14px;
  left: 3px;
  bottom: 3px;
  background-color: white;
  transition: 0.4s;
  border-radius: 50%;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:checked + .slider:before {
  transform: translateX(14px);
}

</style>
@section('content')
    <div class="az-content-breadcrumb">
        <span>RATE OF Print Preference</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Print Preference <span>
            @can('Discounts add')
                <a id="addbtn" href="{{ route('printPreference.create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Add Print Preference </a>
            @endcan
        </span></h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">

                <div>
                    <table id="example2" class="table table-striped">
                        {{-- <thead>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Printer Name</th>
                                <th class="wd-10p">Permission </th>
                            </tr>
                        </thead> --}}
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Printer Name</th>
                                <th>Permission</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($preferences as $key => $preference)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $preference->type }}</td>
                                    <td>
                                        <label class="switch">
                                            <input type="checkbox" class="permission-checkbox" data-id="{{ $preference->id }}"
                                                   {{ $preference->type == 'enabled' ? 'checked' : '' }}>
                                            <span class="slider round"></span>
                                        </label>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>


                        <tfoot>
                            <tr>
                                <th class="wd-10p">S.No</th>
                                <th class="wd-10p">Printer Name</th>
                                <th class="wd-10p">Permission </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>


    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Print Preference?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>



@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.permission-checkbox').forEach(function (checkbox) {
                checkbox.addEventListener('change', function () {
                    const id = this.dataset.id;
                    const isChecked = this.checked;

                    fetch(`/update-permission/${id}`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        },
                        body: JSON.stringify({ type: isChecked ? 'enabled' : 'disabled' }),
                    })
                        .then((response) => response.json())
                        .then((data) => {
                            alert(data.message);
                        })
                        .catch((error) => console.error('Error:', error));
                });
            });
        });
    </script>
@endpush
