<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt Voucher</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            margin: 20px;
        }

        .voucher-container {
            max-width: 800px;
            margin: auto;
            background-color: white;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .voucher-header {
            text-align: center;
            margin-bottom: 20px;
        }

        .voucher-header h4 {
            margin: 0;
            font-weight: bold;
        }

        .voucher-header h5 {
            margin-top: 10px;
            font-weight: normal;
        }

        .voucher-details {
            margin-bottom: 20px;
        }

        .voucher-details td {
            padding: 5px;
        }

        .voucher-table th,
        .voucher-table td {
            text-align: right;
            padding: 5px;
            border: 1px solid #ccc;
        }

        .voucher-table th {
            background-color: #f1f1f1;
        }

        .voucher-footer {
            margin-top: 20px;
            text-align: center;
        }

        .voucher-footer div {
            display: inline-block;
            width: 150px;
            margin: 10px;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }

        .invoice-header {
            text-align: center;
            margin-bottom: 20px;
        }

        .invoice-header h2 {
            font-size: 24px;
            margin: 0;
        }

        .invoice-table th,
        .invoice-table td {
            text-align: center;
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 10px;
        }

        .invoice-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }

        .total-row td {
            font-weight: bold;
            background-color: #e9ecef;
        }

        .text-center {
            margin-top: 30px;
            text-align: right;
        }
    </style>
</head>

<body>

    <!-- Cash Receipt Voucher -->
    <div class="voucher-container">
        <div class="voucher-header">
            <h4>M.D.S</h4>
            <h5>CASH RECEIPT VOUCHER</h5>
        </div>

        <div class="voucher-details">
            <table class="table table-borderless">
                <tr>
                    <td>User: <strong>FAHAD</strong></td>
                    <td>No.: <strong>8026</strong></td>
                </tr>
                <tr>
                    <td>Entry Date & Time: <strong>09/09/2024 01:50 PM</strong></td>
                    <td>Dated: <strong>09/09/2024</strong></td>
                </tr>
            </table>
            <div class="mb-3">
                <strong>Invoice No:</strong> <span class="border-bottom d-inline-block w-100"></span>
            </div>
        </div>

        <table class="voucher-table table table-bordered">
            <thead>
                <tr>
                    <th class="text-left">نمبر</th>
                    <th class="text-left">کوڈ</th>
                    <th class="text-left">تفصیل</th>
                    <th class="text-right">رقم</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>20-02-00-0340</td>
                    <td class="text-left">اسد نور علی</td>
                    <td class="text-right">16,475</td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>20-02-00-0921</td>
                    <td class="text-left">پرانا آتھمی عباس</td>
                    <td class="text-right">6,555</td>
                </tr>
                <tr>
                    <td>3</td>
                    <td>20-02-00-0530</td>
                    <td class="text-left">نذیر محمد مندی</td>
                    <td class="text-right">100,000</td>
                </tr>
                <tr>
                    <td>4</td>
                    <td>20-02-00-0648</td>
                    <td class="text-left">شان فیصل میدانی</td>
                    <td class="text-right">15,000</td>
                </tr>
                <tr>
                    <td>5</td>
                    <td>20-02-00-0192</td>
                    <td class="text-left">شیر محمد احمد حق</td>
                    <td class="text-right">80,000</td>
                </tr>
                <tr>
                    <td>6</td>
                    <td>20-02-00-0082</td>
                    <td class="text-left">گل زبیر</td>
                    <td class="text-right">500,000</td>
                </tr>
                <tr>
                    <td>7</td>
                    <td>20-02-00-0182</td>
                    <td class="text-left">صابر زادہ</td>
                    <td class="text-right">135,804</td>
                </tr>
                <tr>
                    <td>8</td>
                    <td>20-02-00-0073</td>
                    <td class="text-left">شاکر اللہ</td>
                    <td class="text-right">100,000</td>
                </tr>
            </tbody>
        </table>

        <div class="text-right">
            <strong>Total:</strong> 953,834
        </div>

        <div class="text-right">
            Net Amount in Words: Rupees: Nine Hundred Fifty Three Thousand Eight Hundred Thirty Four Only
        </div>

        <div class="voucher-footer">
            <div>Checked By</div>
            <div>Manager</div>
            <div>Approved By</div>
            <div>Received By</div>
        </div>

        <div class="mt-3 text-center">
            <small>Print Date & Time: 10/09/2024 11:14 AM</small>
        </div>
    </div>

    <!-- Bootstrap JS (Optional, for any Bootstrap functionalities like modals) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
