@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Brands & Products</span>
        <span>Edit Product</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Edit Product
        <span>
            <a href="{{ route('products.list', Crypt::encrypt($product->brands_id)) }}" class="btn border"
                style="float: right"><i class="fa-solid fa-bars-staggered"></i>
                Back to Products
            </a>
        </span>
    </h2>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Update Product Details</h5>
                @if (Session('alert'))
                    <div class="alert alert-card alert-<?php echo Session('alert-class'); ?>" role="alert">
                        <?php echo Session('alert'); ?>
                        <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                    </div>
                @endif
                <form action="{{ route('products.update', Crypt::encrypt($product->id_products)) }}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <input type="hidden" name="brand_id" value="{{ $product->brands_id }}">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Product Name <span
                                            style="color:red;">*</span></label>
                                    <input name="product_name" id="product_name" class="form-control"
                                        value="{{ old('product_name', $product->products_name) }}" />
                                    @error('product_name')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                        for="id_products_category">Product Category
                                        <span style="color:red;">*</span></label>
                                    <select id="id_products_category" name="id_products_category" class="form-control">
                                        <option value="">Select Category</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id_products_category }}"
                                                {{ old('id_products_category', $product->category_id) == $category->id_products_category ? 'selected' : '' }}>
                                                {{ $category->products_category_name }} |
                                                {{ $category->products_category_name_urdu }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('id_products_category')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="product_unit">
                                        Product Unit
                                    </label>
                                    <select id="product_unit" name="product_unit" class="form-control">
                                        <option value="">Select Unit</option>
                                        @foreach ($units as $unit)
                                            <option value="{{ $unit->id_measurement_unit }}"
                                                {{ old('product_unit', $product->measurement_unit_id) == $unit->id_measurement_unit ? 'selected' : '' }}>
                                                {{ $unit->measurement_unit_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('product_unit')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                        for="product_status">Status</label>
                                    <select id="product_status" name="product_status" class="form-control">
                                        <option value="">Select</option>
                                        <option value="1"
                                            {{ old('product_status', $product->products_status) == '1' ? 'selected' : '' }}>
                                            Active</option>
                                        <option value="0"
                                            {{ old('product_status', $product->products_status) == '0' ? 'selected' : '' }}>
                                            Inactive</option>
                                    </select>
                                    @error('product_status')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                        for="product_desc">Description</label>
                                    <textarea name="product_desc" id="product_desc" class="form-control" cols="30" rows="10">{{ old('product_desc', $product->products_desc) }}</textarea>
                                    @error('product_desc')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <a href="{{ route('products.list', Crypt::encrypt($product->brands_id)) }}"
                        class="btn btn-danger btn-block mt-2">Cancel</a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Update</button>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
@endsection
