@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Purchaser</span>
        <span>Edit Purchaser</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Edit Purchaser
        <span> <a href="{{ route('purchaser.list') }}" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to Purchaser
            </a></span>
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Edit Purchaser Details</h5>
                <form method="POST" action="{{ route('purchaser.update', \Crypt::encrypt($edit->id_purchaser)) }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Purchaser Name (English) <span style="color:red;">*</span></label>
                                <input type="text" name="purchaser_name" value="{{ $edit->purchaser_name }}"
                                    class="form-control" required />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="" style="float: inline-end;">کھا تہ </label>
                                <input type="text" name="purchaser_name_urdu" value="{{ $edit->purchaser_name_urdu }}"
                                    class="form-control" id="purchaser_name_urdu" dir="rtl" />
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Email</label>
                                <input type="text" name="email" value="{{ $edit->purchaser_email }}"
                                    class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Contact Person</label>
                                <input type="text" name="contact_person" value="{{ $edit->contact_person }}"
                                    class="form-control" />
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Address (English)</label>
                                <input type="text" name="address" value="{{ $edit->purchaser_address }}"
                                    class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label style="float: inline-end;"> گاہک کا پتہ </label>
                                <input type="text" name="purchaser_address_urdu"
                                    value="{{ $edit->purchaser_address_urdu }}" class="form-control"
                                    id="purchaser_address_urdu" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">City</label>
                                <select class="form-control" name="city" id="city">
                                    <option value="">- Select -</option>
                                    @foreach ($cities as $key => $city)
                                        <option value="{{ $city->id_city }}"
                                            {{ $city->id_city == $edit->purchaser_city ? 'selected' : '' }}>
                                            {{ $city->city_name }} | {{ $city->city_name_urdu }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Phone 1</label>
                                <input type="text" name="phone_1" value="{{ $edit->phone_1 }}" class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Phone 2</label>
                                <input type="text" name="phone_2" value="{{ $edit->phone_2 }}"
                                    class="form-control" />
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Website</label>
                                <input type="text" name="website" value="{{ $edit->website }}"
                                    class="form-control" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Status</label>
                                <select class="form-control" name="status">
                                    <option value="0" {{ $edit->status == 0 ? 'selected' : '' }}>Active</option>
                                    <option value="1" {{ $edit->status == 1 ? 'selected' : '' }}>In-Active</option>
                                </select>
                            </div>
                        </div>
                    </div>



                    <a href="{{ route('purchaser.list') }}" class="btn btn-danger btn-block mt-2">Cancel</a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Update</button>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $("#opening_date").datepicker({
                dateFormat: "yy-mm-dd" // You can customize the date format here
            });

            $('#city').select2({
                theme: 'default'
            });
        });


        // document.getElementById('purchaser_name_urdu').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;
        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });

        // document.getElementById('purchaser_address_urdu').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;
        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });
    </script>
@endpush
