<!DOCTYPE html>
<html>

<head>
    <title>General Ledger - Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .container {
            width: 95%;
            margin: auto;
        }

        h2,
        p {
            text-align: center;
        }

        /* 2 Columns */
        .columns {
            display: flex;
            gap: 20px;
        }

        .col {
            width: 100%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th,
        td {
            padding: 6px;
            border: 2px solid black;
            text-align: right;
        }

        .no-print {
            margin-top: 20px;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>M.D.S</h2>
        <p>General Ledger &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; رجسٹر</p>



        <div class="columns">
            <div class="col">
                <table>
                    <thead>
                        <tr>
                            <th>تاریخ</th>
                            <th>تفصیل</th>
                            <th>ڈیبٹ رقم</th>
                            <th>کریڈٹ رقم</th>
                            <th>میزان</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <span style="float: left">کھاتہ کوڈ</span>
                        <span style="float: right">کھاتہ</span>
                        {{-- {{ dd($salesByCustomer) }} --}}
                        @foreach ($sales as $sale)
                            <tr>
                                <td>{{ number_format($sale->today_balance, 0) ?? '-' }}</td>
                                <td>{{ number_format($sale->yesterday_balance, 0) ?? '-' }}</td>
                                <td>{{ number_format($sale->total_balance, 0) }}</td>
                                <td>{{ $sale->customer?->customer_name_urdu }}</td>
                                <td>{{ $sale->customer?->customer_name_urdu }}</td>
                                <td></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>

        <button class="no-print" onclick="window.print()">Print</button>
    </div>

</body>

</html>
