@extends('layouts.master')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Sale Bill Report</h3>
        </div>
        <div class="card-body">
            <form id="filterForm" class="row" method="POST" action="{{ route('saleBill') }}">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mt-3">
                            <label for="from_date">From Date</label>
                            <input type="date" name="from_date" id="from_date" class="form-control"
                                value="{{ request('from_date') }}">
                            {{-- <input type="text" id="from_date" required autocomplete="off"
                                class="form-control form-filter" name="from_date" placeholder="From"> --}}

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mt-3">
                            <label for="to_date">To Date</label>
                            <input type="date" name="to_date" id="to_date" class="form-control"
                                value="{{ request('to_date') }}">
                            {{-- <input type="text" id="to_date" required autocomplete="off"
                                class="form-control form-filter" name="to_date" placeholder="From"> --}}
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group mt-3">
                            <label>Select Customer</label>
                            <select id="customer_id" name="customer_id" class="form-control select2" required>
                                <option value="">-- Select All Customer --</option>
                                @foreach ($customers as $customer)
                                    <option value="{{ $customer->id_customers }}">{{ $customer->customer_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mt-3">
                            <label>Select All Truck No</label>
                            <select id="truck_no" name="truck_no" class="form-control select2" required></select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group mt-3">
                            <label>Select All Product</label>
                            <select id="product" name="product" class="form-control select2" required></select>
                        </div>
                    </div>
                </div>
                <div class="row mt-5">
                    <div class="col-md-2 text-center">
                        <button type="button" id="fetchReport" class="btn btn-primary"><i class="fa fa-search"></i> Fetch
                            Report</button>
                    </div>
                </div>
            </form>
            <hr />
            <div class="table-responsive">
                <table id="tblreport" class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Customer</th>
                            <th>Date</th>
                            <th>Truck No</th>
                            <th>Products</th>
                            <th>Bori</th>
                            <th>Weight</th>
                            <th>Rate</th>
                            <th>Total</th>
                            <th>Received</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();


            // $('#from_date').datepicker({
            //     autoclose: true,
            //     todayHighlight: true,
            //     format: "dd-M-yyyy" // Ensure the format is supported
            // });

            // $('#to_date').datepicker({
            //     autoclose: true,
            //     todayHighlight: true,
            //     format: "dd-M-yyyy" // Ensure the format is supported
            // });


            $('#customer_id').change(function() {
                const customerId = $(this).val();
                if (customerId) {
                    $.ajax({
                        url: '{{ route('fetchCustomerData') }}',
                        type: 'GET',
                        data: {
                            customer_id: customerId
                        },
                        success: function(response) {
                            populateDropdown('#truck_no', response.trucks, 'truck_no');
                            populateDropdown('#product', response.products,
                                'products_category_name');
                        },
                        error: function() {
                            alert('Failed to fetch customer data.');
                        }
                    });
                }
            });

            $('#fetchReport').click(function() {
                const formData = $('#filterForm').serialize();
                $.ajax({
                    url: '{{ route('fetchReportData') }}',
                    type: 'GET',
                    data: formData,
                    success: function(response) {
                        populateReportTable(response.data);
                    },
                    error: function() {
                        alert('Failed to fetch report data.');
                    }
                });
            });

            function populateDropdown(selector, data, key) {
                const dropdown = $(selector);
                dropdown.empty().append('<option value="">-- Select All --</option>');
                data.forEach(item => {
                    dropdown.append(`<option value="${item[key]}">${item[key]}</option>`);
                });
                dropdown.select2();
            }

            function populateReportTable(data) {
                const tableBody = $('#tblreport tbody');
                tableBody.empty();
                if (data.length > 0) {
                    data.forEach((row, index) => {
                        tableBody.append(`
                            <tr>
                                <td>${index + 1}</td>
                                <td>${row.customer_name}</td>
                                <td>${row.date}</td>
                                <td>${row.truck_no}</td>
                                <td>${row.products_category_name}</td>
                                <td>${row.bori}</td>
                                <td>${row.weight}</td>
                                <td>${row.rate}</td>
                                <td>${row.amount}</td>
                                <td>${row.paid}</td>
                                <td>${row.balance}</td>
                            </tr>
                        `);
                    });
                } else {
                    tableBody.append('<tr><td colspan="11" class="text-center">No records found.</td></tr>');
                }
            }
        });
    </script>
@endpush
