@extends('layouts.master')
@section('content')
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shortcut CRUD</title>
    <!-- Add Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            let ctrlPressed = false;
            let altPressed = false;
            let shiftPressed = false;

            document.addEventListener('keydown', function (event) {
                const activeElement = document.activeElement;

                if (activeElement.tagName === 'INPUT' && activeElement.id !== 'shortcutInputCtrl' && activeElement.id !== 'shortcutInputAlpha') {
                    return;
                }

                if (event.key === 'Control' && !ctrlPressed) {
                    ctrlPressed = true;
                    updateShortcutField();
                }

                if (event.key === 'Alt' && !altPressed) {
                    altPressed = true;
                    updateShortcutField();
                }

                if (event.key === 'Shift' && !shiftPressed) {
                    shiftPressed = true;
                    updateShortcutField();
                }

                if (/^[a-zA-Z]$/.test(event.key) && !ctrlPressed && !altPressed && !shiftPressed) {
                    event.preventDefault();
                    const inputField = document.getElementById('shortcutInputAlpha');
                    if (inputField) {
                        inputField.value = event.key.toUpperCase();
                        inputField.focus();
                    }
                }
            });

            document.addEventListener('keyup', function (event) {
                if (event.key === 'Control') {
                    ctrlPressed = false;
                }
                if (event.key === 'Alt') {
                    altPressed = false;
                }
                if (event.key === 'Shift') {
                    shiftPressed = false;
                }
            });

            function updateShortcutField() {
                const inputField = document.getElementById('shortcutInputCtrl');
                if (inputField) {
                    const keys = [];
                    if (ctrlPressed) keys.push('Ctrl');
                    if (altPressed) keys.push('Alt');
                    if (shiftPressed) keys.push('Shift');
                    inputField.value = keys.join(' + ');
                    inputField.focus();
                }
            }
        });
    </script>


</head>
<body>
    <div>
        <div class="row">
            <div class="col-md-12">
                <div class="card shadow">
                    <div class="card-header text-dark">
                        <h3 class="card-title mb-0">Shortcut Keys</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('shortkut.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="mb-3 col-md-4">
                                    <label for="nameInput" class="form-label">Name:</label>
                                    <input type="text" id="nameInput" name="shortcut_name" class="form-control" placeholder="Enter your name" required>
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label for="shortcutInputCtrl" class="form-label">Shortcut Input for Ctrl:</label>
                                    <input type="text" id="shortcutInputCtrl" name="shortcut_key_1" class="form-control" placeholder="Press Ctrl">
                                </div>
                                <div class="mb-3 col-md-4">
                                    <label for="shortcutInputAlpha" class="form-label">Shortcut Input for Alphabet:</label>
                                    <input type="text" id="shortcutInputAlpha" name="shortcut_key_2" class="form-control" placeholder="Press any alphabet">
                                </div>
                            </div>
                            <div class="d-flex justify-content-between">
                                <a href="{{ route('shortkut.index') }}" class="btn btn-secondary">Back</a>
                                <button type="submit" class="btn btn-success">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
@endsection

