{{-- @extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Print {{ $voucherNumber->voucher_type }}</span>
    </div>
    <h2 class="az-content-title" style="display: inline">Print {{ $voucherNumber->voucher_type }}
    </h2>

    <div class="row" id="printableArea">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <h4>
                        <span><strong>Voucher Number #:</strong> {{ $voucherNumber->voucher_number }}</span><br>
                        <span><strong>Voucher Date:</strong>
                            {{ date('d-m-Y', strtotime($voucherNumber->created_at)) }}</span><br>
                        <span><strong>Voucher Type:</strong> {{ $voucherNumber->voucher_type }}</span><br>
                        <span><strong>Business Partner:</strong>
                            {{ $voucherNumber->vouchers->first()->partner_name }}</span><br>
                        <span><strong>Description:</strong> {{ $voucherNumber->vouchers->first()->description }}</span>
                    </h4>
                </div>
                <div class="mt-5">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>S.No</th>
                                <th>Account Number</th>
                                <th>Account Title</th>
                                <th>Payment Mode</th>
                                <th>Instrument #</th>
                                <th>Remarks</th>
                                <th>Debit</th>
                                <th>Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($voucherNumber->vouchers as $voucher)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $voucher->account_no }}</td>
                                    <td>{{ $voucher->account_title }}</td>
                                    <td>{{ $voucher->payment_mode }}</td>
                                    <td>{{ $voucher->instrument }}</td>
                                    <td>{{ $voucher->remarks }}</td>
                                    <td>{{ $voucher->debit }}</td>
                                    <td>{{ $voucher->credit }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="float-end">
                        <h5>Total Debit: {{ $voucherNumber->vouchers->sum('debit') }}</h5>
                        <h5>Total Credit: {{ $voucherNumber->vouchers->sum('credit') }}</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function printDiv() {
            var printContents = document.getElementById('printableArea').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }

        window.onload = function() {
            printDiv();
        };
    </script>
@endpush --}}


@extends('layouts.master')

@push('css')
    <style>
        .panel-body h4,
        .panel-body h5 {
            font-weight: bold;
        }

        .table th,
        .table td {
            vertical-align: middle;
            text-align: center;
        }

        .table tfoot th {
            text-align: right;
        }

        .print-btn {
            display: inline-block;
            margin-top: 20px;
        }

        @media print {
            .hidden-print {
                display: none !important;
            }
        }
    </style>
@endpush

@section('content')
    <div class="printableArea">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-body card ">
                        <div class="card-body p-3">
                            <div class="d-flex justify-content-between">
                                <h4 class="">View Voucher</h4>
                                <div class="text-right">
                                    <h4>Voucher Number #<br><strong>{{ $voucherDetails->voucher_number }}</strong></h4>
                                    <h4>Voucher Date
                                        <br><strong>{{ date('d-m-Y', strtotime($voucherDetails->created_at)) }}</strong>
                                    </h4>
                                </div>
                            </div>

                            <div class="clearfix"></div>
                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <h5><strong>Voucher Type:</strong> {{ $voucherDetails->voucher_type }}</h5>
                                    <h5><strong>Status:</strong> {{ $vou_other_detail->status }}</h5>
                                    <h5><strong>Business Partner:</strong> {{ $vou_other_detail->partner_name }}</h5>
                                    <h5><strong>Description:</strong> {{ $vou_other_detail->desciption }}</h5>
                                </div>
                            </div>
                            <hr>
                            <div class="table-responsive">
                                <table id="transactiontable" class="table table-hover table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th scope="col">Account Number</th>
                                            <th scope="col">Account Title</th>
                                            <th scope="col">Payment Mode</th>
                                            <th scope="col">Instrument #</th>
                                            <th scope="col">Cost Center</th>
                                            <th scope="col">Remarks</th>
                                            <th scope="col" class="text-primary">Debit</th>
                                            <th scope="col" class="text-primary">Credit</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $totalDebit = 0; $totalCredit = 0; ?>
                                        @foreach ($accountVouchers as $voucher)
                                            <tr>
                                                <td>{{ $voucher->account_no }}</td>
                                                <td>{{ $voucher->account_title }}</td>
                                                <td>{{ $voucher->payment_mode }}</td>
                                                <td>{{ $voucher->instrument }}</td>
                                                <td>{{ $voucher->cost_center_name }}</td>
                                                <td>{{ $voucher->remarks }}</td>
                                                <td>{{ $voucher->debit }}</td>
                                                <td>{{ $voucher->credit }}</td>
                                            </tr>
                                            <?php $totalDebit += $voucher->debit; $totalCredit += $voucher->credit; ?>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="6" class="text-right">Total</th>
                                            <th>{{ number_format($totalDebit, 2) }}</th>
                                            <th>{{ number_format($totalCredit, 2) }}</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div class="hidden-print">
                                <button class="btn btn-success print-btn text-light" onclick="window.print()">
                                    <span><i class="fa fa-print"></i> Print</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function printDiv() {
            var printContents = document.getElementById('printableArea').innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }

        window.onload = function() {
            printDiv();
        };
    </script>
@endpush
