<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerPaymentHistory extends Model
{
    protected $table = 'customers_payment_history';
    protected $primaryKey = 'id_customers_payment_history';

    protected $fillable = [
        'customers_id',
        'invoice_no',
        'invoice_date',
        'amount',
        'status',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customers_id');
    }
}
