<?php

namespace App\Http\Controllers;

use App\Sale;
use App\SalesItemDetail;
use App\SalesPerBoriWeight;
use App\Customer;
use App\Suppliers;
use App\GoodReceipts;
use App\GoodReceiptTruck;
use App\GoodReceiptDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class SalesController extends Controller
{

    protected string $module = 'Sales';

    public function __construct()
    {
        $module = $this->module;

        $this->middleware("permission:$module list")->only(['index']);
        $this->middleware("permission:$module view")->only(['show']);
        $this->middleware("permission:$module add")->only(['create', 'store']);
        $this->middleware("permission:$module edit")->only(['edit', 'update']);
        $this->middleware("permission:$module delete")->only(['destroy']);
    }

    // protected $role_id;
    // public function __construct()
    // {
    //     $this->middleware('auth');
    //     $this->middleware(function ($request, $next) {
    //         $this->role_id = Auth::user()->role_id;
    //     //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //     //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //     $ex = explode('/',$request->path());
    //     if(count($ex)>=3){
    //         $sliced = array_slice($ex, 0, -1);

    //     }else{
    //         $sliced = $ex;
    //     }

    //     $string = implode("/", $sliced);
    //         if (checkConstructor($this->role_id, count($ex)>=3 ? $string.'/': $string) == 1) {
    //             return $next($request);
    //         }else if(strpos($request->path(), 'store') !== false){
    //             return $next($request);
    //         }else if(strpos($request->path(), 'update') !== false){
    //             return $next($request);
    //         } else {
    //             abort(404);
    //         }
    //     });
    // }

    public function index()
    {
        $sales = Sale::with(['salesItemsDetails', 'salesPerBoriWeight', 'customer', 'goodReceiptTruck', 'goodReceiptTruck.goodReceiptDetails'])->OrderBy('id_sales', 'DESC')->get();
        //        dd($sales);
        return view('sales.index', compact('sales'));
    }

    // public function create()
    // {
    //     // $trucks = GoodReceiptTruck::with('goodReceipts.goodReceiptDetails')->get();
    //     $trucks = GoodReceiptTruck::with([
    //         'goodReceipts' => function ($query) {
    //             $query->with(['goodReceiptDetails.productMainCate', 'goodReceiptDetails.productParentCate', 'goodReceiptDetails.productChildCate', 'supplier']);
    //         }
    //     ])->get();
    //     $customers = Customer::all();
    //     return view('sales.create', compact('trucks', 'customers'));
    // }

    public function create()
    {
        $trucks = GoodReceiptTruck::with([
            'goodReceipts' => function ($query) {
                $query->with([
                    'goodReceiptDetails' => function ($query) {
                        // Only get good receipt details where bori is greater than 0
                        $query->where('bori', '>', 0)
                            ->with(['productMainCate', 'productParentCate', 'productChildCate']);
                    },
                    'supplier'
                ]);
            }
        ])->get();

        $customers = Customer::all();
        return view('sales.create', compact('trucks', 'customers'));
    }


    // public function store(Request $request)
    // {
    //     // Validate the request data
    //     $request->validate([
    //         'sales_date' => 'required|date',
    //         // 's_no' => 'required|string',
    //         'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
    //         'customer_id' => 'required|exists:customers,id_customers',
    //         'bill_no' => 'nullable|string',
    //         'details' => 'nullable|string',
    //         'bori_details' => 'nullable|string',
    //         'total_bori' => 'nullable|numeric',
    //         'remaining_amount' => 'nullable|numeric',
    //         'cash_received' => 'nullable|numeric',
    //         'total_amount' => 'nullable|numeric',
    //         'items_name.*' => 'nullable|string',
    //         'marka.*' => 'nullable|string',
    //         'bori.*' => 'nullable|numeric',
    //         'weight.*' => 'nullable|numeric',
    //         'rate.*' => 'nullable|numeric',
    //         'amount.*' => 'nullable|numeric',
    //         'bori_number.*' => 'nullable|string',
    //         'per_bori_weight.*' => 'nullable|numeric',
    //     ]);
    //     // Sales
    //     // dd($request);
    //     $sale = Sale::create([
    //         'business_id' => auth()->user()->business_id,
    //         'good_receipts_truck_id' => $request->good_receipts_truck_id,
    //         'customer_id' => $request->customer_id,
    //         'date' => $request->sales_date,
    //         // 's_no' => $request->s_no,
    //         'bill_no' => $request->bill_no,
    //         'details' => $request->details,
    //         'bori_details' => $request->bori_details,
    //         'balance' => $request->remaining_amount,
    //         'paid' => $request->cash_received,
    //         'total_amount' => $request->total_amount,
    //         'status' => $request->sales_status,
    //         'created_by' => auth()->id(),
    //     ]);

    //     // Handle Item Details
    //     $items = $request->items_name ?? [];
    //     $marka = $request->marka ?? [];
    //     $bori = $request->bori ?? [];
    //     $weight = $request->weight ?? [];
    //     $rate = $request->rate ?? [];
    //     $amount = $request->amount ?? [];

    //     foreach ($items as $index => $item) {
    //         // Ensure that all related fields are set
    //         SalesItemDetail::create([
    //             'sales_id' => $sale->id_sales,
    //             'items_name' => $item,
    //             'marka' => $marka[$index] ?? null,
    //             'bori' => $bori[$index] ?? null,
    //             'weight' => $weight[$index] ?? null,
    //             'rate' => $rate[$index] ?? null,
    //             'amount' => $amount[$index] ?? 0,
    //             'notes' => 'N/A',
    //             'status' => '1',
    //         ]);
    //     }

    //     // Handle Additional Bori Details
    //     $bori_num = $request->bori_number ?? [];
    //     $bori_weight = $request->per_bori_weight ?? [];

    //     foreach ($bori_num as $index => $bori) {
    //         SalesPerBoriWeight::create([
    //             'sales_id' => $sale->id_sales,
    //             'bori_number' => $bori,
    //             'per_bori_weight' => $bori_weight[$index] ?? null,
    //         ]);
    //     }

    //     return redirect()->route('sales.list')->with('success', 'Sale created successfully');
    // }


    public function store(Request $request)
    {
        // dd($request);
        $request->validate([
            'sales_date' => 'required|date',
            'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
            'good_receipts_truck_ids' => 'required|exists:good_receipts_truck,id_truck',
            'good_receipts_truck_ids.*' => 'required|exists:good_receipts_truck,id_truck',

            'customer_id' => 'required|exists:customers,id_customers',
            'sales_status' => 'required|in:0,1',

            'good_receipt_detail_id'   => 'required|array|min:1',
            'good_receipt_detail_id.*' => 'required|exists:good_receipts_details,id_grd',

            'bori'   => 'required|array',
            'bori.*' => 'nullable|numeric|min:0',

            'weight'   => 'required|array',
            'weight.*' => 'nullable|numeric|min:0',

            'rate'   => 'required|array',
            'rate.*' => 'nullable|numeric|min:0',

            'amount'   => 'required|array',
            'amount.*' => 'nullable|numeric|min:0',

            'total_amount' => 'required|numeric|min:0',
            'remaining_amount' => 'nullable|numeric|min:0',
            'cash_received' => 'nullable|numeric|min:0',
        ]);

        $hasValidItem = false;

        foreach ($request->bori as $i => $bori) {
            $weight = $request->weight[$i] ?? 0;

            if ($bori > 0 || $weight > 0) {
                $hasValidItem = true;
                break;
            }
        }

        if (!$hasValidItem) {
            return back()
                ->withInput()
                ->with('error', 'At least one item with bori or weight is required.');
        }


        DB::beginTransaction();

        try {


            $sale = Sale::create([
                'business_id' => auth()->user()->business_id,
                'good_receipts_truck_id' => $request->good_receipts_truck_id,
                'customer_id' => $request->customer_id,
                'date' => $request->sales_date,
                'bill_no' => $request->bill_no,
                'details' => $request->details,
                'bori_details' => $request->bori_details,
                'balance' => $request->remaining_amount,
                'paid' => $request->cash_received,
                'total_amount' => $request->total_amount,
                'status' => $request->sales_status,
                'created_by' => auth()->user()->id,
            ]);


            foreach ($request->good_receipt_detail_id as $index => $detailId) {

                $bori   =  ($request->bori[$index] ?? 0);
                $weight =  ($request->weight[$index] ?? 0);


                if ($bori <= 0 && $weight <= 0) {
                    throw new \Exception('Invalid item: bori or weight required.');
                }


                $goodDetail = GoodReceiptDetail::lockForUpdate()
                    ->where('id_grd', $detailId)
                    ->first();

                if (!$goodDetail) {
                    throw new \Exception('Stock record not found.');
                }

                if ($goodDetail->bori < $bori) {
                    throw new \Exception(
                        "Insufficient bori stock for item ID: {$detailId}"
                    );
                }



                $goodDetail->update([
                    'bori' => $goodDetail->bori - $bori,
                ]);

                // =========================
                // 9️⃣ CREATE SALES ITEM
                // =========================
                SalesItemDetail::create([
                    'sales_id' => $sale->id_sales,
                    'good_detail_id' => $detailId,
                    'items_main_cate' => $goodDetail->pro_cate_main_id,
                    'items_parent_cate' => $goodDetail->pro_cate_parent_id,
                    'items_child_cate' => $goodDetail->pro_cate_child_id,
                    'marka' => $goodDetail->marka,
                    'bori' => $bori,
                    'weight' => $weight,
                    'rate' => $request->rate[$index] ?? 0,
                    'good_receipts_truck_id' => $request->good_receipts_truck_ids[$index] ?? 0,
                    'amount' => $request->amount[$index] ?? 0,
                    'notes' => 'N/A',
                    'status' => 1,
                ]);

                if (!empty($request->bori_number)) {

                    foreach ($request->bori_number as $index => $boriNo) {

                        SalesPerBoriWeight::create([
                            'sales_id' => $sale->id_sales,
                            'bori_number' => $boriNo,
                            'per_bori_weight' =>
                            $request->per_bori_weight[$index] ?? null,
                        ]);
                    }
                }
            }


            DB::commit();

            return redirect()
                ->route('sales.list')
                ->with('success', 'Sale created successfully.');
        } catch (\Exception $e) {

            DB::rollBack();

            return back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }


    public function edit($id)
    {
        $sale = Sale::with('salesItemsDetails', 'salesItemsDetails.goodReceiptDetail', 'salesPerBoriWeight')->findOrFail(Crypt::decrypt($id));
        // dd($sale);
        // $trucks = GoodReceiptTruck::all();
        // $trucks = GoodReceiptTruck::with([
        //     'goodReceipts' => function ($query) {
        //         $query->with(['goodReceiptDetails.productMainCate', 'goodReceiptDetails.productParentCate', 'goodReceiptDetails.productChildCate', 'supplier']);
        //     }
        // ])->get();
        $trucks = GoodReceiptTruck::with([
            'goodReceipts' => function ($query) {
                $query->with([
                    'goodReceiptDetails' => function ($query) {
                        // Only get good receipt details where bori is greater than 0
                        $query->where('bori', '>', 0)
                            ->with(['productMainCate', 'productParentCate', 'productChildCate']);
                    },
                    'supplier'
                ]);
            }
        ])->get();
        $customers = Customer::all();

        return view('sales.edit', compact('sale', 'trucks', 'customers'));
    }

    public function update(Request $request, $id)
    {
        // dd($request);
        $request->validate([
            'sales_date' => 'required|date',
            'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
            'good_receipts_truck_ids' => 'required|exists:good_receipts_truck,id_truck',
            'good_receipts_truck_ids.*' => 'required|exists:good_receipts_truck,id_truck',
            'customer_id' => 'required|exists:customers,id_customers',
            'sales_status' => 'required|in:0,1',

            'good_receipt_detail_id'   => 'required|array|min:1',
            'good_receipt_detail_id.*' => 'required|exists:good_receipts_details,id_grd',


            'bori'   => 'required|array',
            'bori.*' => 'nullable|numeric|min:0',

            'weight'   => 'required|array',
            'weight.*' => 'nullable|numeric|min:0',

            'rate'   => 'required|array',
            'rate.*' => 'nullable|numeric|min:0',

            'amount'   => 'required|array',
            'amount.*' => 'nullable|numeric|min:0',

            'total_amount' => 'required|numeric|min:0',
            'remaining_amount' => 'nullable|numeric|min:0',
            'cash_received' => 'nullable|numeric|min:0',
        ]);

        $hasValidItem = false;
        foreach ($request->bori as $i => $bori) {
            $weight = $request->weight[$i] ?? 0;
            if ($bori > 0 || $weight > 0) {
                $hasValidItem = true;
                break;
            }
        }

        if (!$hasValidItem) {
            return back()
                ->withInput()
                ->with('error', 'At least one item with bori or weight is required.');
        }

        DB::beginTransaction();

        try {

            $dec_id = Crypt::decrypt($id);
            $sale = Sale::with('salesItemsDetails')->where('id_sales', $dec_id)->firstOrFail();


            foreach ($sale->salesItemsDetails as $oldItem) {

                $goodDetail = GoodReceiptDetail::lockForUpdate()
                    ->where('id_grd', $oldItem->good_detail_id)
                    ->first();

                if ($goodDetail) {
                    $goodDetail->increment('bori', $oldItem->bori);
                }
            }


            SalesItemDetail::where('sales_id', $sale->id_sales)->delete();
            SalesPerBoriWeight::where('sales_id', $sale->id_sales)->delete();


            $sale->update([
                'good_receipts_truck_id' => $request->good_receipts_truck_id,
                'customer_id' => $request->customer_id,
                'date' => $request->sales_date,
                'bill_no' => $request->bill_no,
                'details' => $request->details,
                'bori_details' => $request->bori_details,
                'balance' => $request->remaining_amount,
                'paid' => $request->cash_received,
                'total_amount' => $request->total_amount,
                'status' => $request->sales_status,
                'updated_by' => auth()->user()->id,
            ]);


            foreach ($request->good_receipt_detail_id as $index => $detailId) {

                $bori   = $request->bori[$index] ?? 0;
                $weight = $request->weight[$index] ?? 0;

                if ($bori <= 0 && $weight <= 0) {
                    continue;
                }

                $goodDetail = GoodReceiptDetail::lockForUpdate()
                    ->where('id_grd', $detailId)
                    ->firstOrFail();

                if ($goodDetail->bori < $bori) {
                    throw new \Exception("Insufficient bori stock for item ID: {$detailId}");
                }

                $goodDetail->decrement('bori', $bori);

                SalesItemDetail::create([
                    'sales_id' => $sale->id_sales,
                    'good_detail_id' => $detailId,
                    'items_main_cate' => $goodDetail->pro_cate_main_id,
                    'items_parent_cate' => $goodDetail->pro_cate_parent_id,
                    'items_child_cate' => $goodDetail->pro_cate_child_id,
                    'marka' => $goodDetail->marka,
                    'bori' => $bori,
                    'weight' => $weight,
                    'rate' => $request->rate[$index] ?? 0,
                    'amount' => $request->amount[$index] ?? 0,
                    'good_receipts_truck_id' => $request->good_receipts_truck_ids[$index] ?? 0,
                    'notes' => 'N/A',
                    'status' => 1,
                ]);
            }


            if (!empty($request->bori_number)) {
                foreach ($request->bori_number as $i => $boriNo) {
                    SalesPerBoriWeight::create([
                        'sales_id' => $sale->id_sales,
                        'bori_number' => $boriNo,
                        'per_bori_weight' => $request->per_bori_weight[$i] ?? null,
                    ]);
                }
            }

            DB::commit();

            return redirect()
                ->route('sales.list')
                ->with('success', 'Sale updated successfully.');
        } catch (\Exception $e) {

            DB::rollBack();

            return back()
                ->withInput()
                ->with('error', $e->getMessage());
        }
    }

    // old base
    // public function update(Request $request, $id)
    // {
    //     // Validate the request data
    //     $request->validate([
    //         'sales_date' => 'required|date',
    //         // 's_no' => 'required|string',
    //         'good_receipts_truck_id' => 'required|exists:good_receipts_truck,id_truck',
    //         'customer_id' => 'required|exists:customers,id_customers',
    //         'bill_no' => 'required|string',
    //         'details' => 'nullable|string',
    //         'bori_details' => 'nullable|string',
    //         'total_bori' => 'nullable|numeric',
    //         'remaining_amount' => 'nullable|numeric',
    //         'cash_received' => 'nullable|numeric',
    //         'total_amount' => 'nullable|numeric',
    //         'items_name.*' => 'nullable|string',
    //         'marka.*' => 'nullable|string',
    //         'bori.*' => 'nullable|numeric',
    //         'weight.*' => 'nullable|numeric',
    //         'rate.*' => 'nullable|numeric',
    //         'amount.*' => 'nullable|numeric',
    //         'item_detail_ids.*' => 'nullable|integer',
    //         'bori_number.*' => 'nullable|string',
    //         'per_bori_weight.*' => 'nullable|numeric',
    //         'bori_detail_ids.*' => 'nullable|integer',
    //     ]);

    //     // Start transaction
    //     DB::beginTransaction();

    //     try {
    //         // Find the sale to update
    //         $sale = Sale::findOrFail(Crypt::decrypt($id));

    //         // Update sale details
    //         $sale->update([
    //             'date' => $request->sales_date,
    //             // 's_no' => $request->s_no,
    //             'good_receipts_truck_id' => $request->good_receipts_truck_id,
    //             'customer_id' => $request->customer_id,
    //             'bill_no' => $request->bill_no,
    //             'details' => $request->details,
    //             'bori_details' => $request->bori_details,
    //             'balance' => $request->remaining_amount,
    //             'paid' => $request->cash_received,
    //             'total_amount' => $request->total_amount,
    //             'status' => $request->sales_status,
    //         ]);

    //         // Handle SalesItemDetails
    //         $itemsNames = $request->items_name ?? [];
    //         $existingItemIds = $request->item_detail_ids ?? [];
    //         $existingItems = $sale->salesItemsDetails->pluck('id_sid')->toArray();

    //         foreach ($itemsNames as $index => $itemName) {
    //             $itemData = [
    //                 'items_name' => $itemName,
    //                 'marka' => $request->marka[$index] ?? null,
    //                 'bori' => $request->bori[$index] ?? null,
    //                 'weight' => $request->weight[$index] ?? null,
    //                 'rate' => $request->rate[$index] ?? null,
    //                 'amount' => $request->amount[$index] ?? 0,
    //                 'notes' => 'N/A',
    //                 'status' => '1',
    //             ];

    //             $itemId = $request->item_detail_ids[$index] ?? null;

    //             if ($itemId) {
    //                 // Update existing item
    //                 $itemDetail = SalesItemDetail::find($itemId);
    //                 if ($itemDetail) {
    //                     $itemDetail->update($itemData);
    //                 }
    //             } else {
    //                 // Create new item
    //                 $sale->salesItemsDetails()->create($itemData);
    //             }
    //         }

    //         // Delete removed items
    //         $itemsToDelete = array_diff($existingItems, $existingItemIds);
    //         SalesItemDetail::whereIn('id_sid', $itemsToDelete)->delete();

    //         // Handle SalesPerBoriWeight
    //         $boriNumbers = $request->bori_number ?? [];
    //         $existingBoriIds = $request->bori_detail_ids ?? [];
    //         $existingBoris = $sale->salesPerBoriWeight->pluck('id_sales_per_bw')->toArray();

    //         foreach ($boriNumbers as $index => $boriNumber) {
    //             $boriData = [
    //                 'bori_number' => $boriNumber,
    //                 'per_bori_weight' => $request->per_bori_weight[$index] ?? null,
    //             ];

    //             $boriId = $request->bori_detail_ids[$index] ?? null;

    //             if ($boriId) {
    //                 // Update existing bori detail
    //                 $boriDetail = SalesPerBoriWeight::find($boriId);
    //                 if ($boriDetail) {
    //                     $boriDetail->update($boriData);
    //                 }
    //             } else {
    //                 // Create new bori detail
    //                 $boriData['sales_id'] = $sale->id_sales;
    //                 SalesPerBoriWeight::create($boriData);
    //             }
    //         }

    //         // Delete removed bori details
    //         $borisToDelete = array_diff($existingBoris, $existingBoriIds);
    //         SalesPerBoriWeight::whereIn('id_sales_per_bw', $borisToDelete)->delete();

    //         // Commit transaction
    //         DB::commit();

    //         return redirect()->route('sales.list')->with('success', 'Sale updated successfully');
    //     } catch (\Exception $e) {
    //         // Rollback transaction
    //         DB::rollBack();
    //         return redirect()->back()->with('error', 'Error updating sale: ' . $e->getMessage());
    //     }
    // }

    public function destroy($id)
    {
        $sale = Sale::with([
            'salesItemsDetails',
            'salesItemsDetails.goodReceiptDetail'
        ])->findOrFail(Crypt::decrypt($id));


        foreach ($sale->salesItemsDetails as $detail) {

            $grDetail = $detail->goodReceiptDetail;

            if ($grDetail) {
                $grDetail->bori += $detail->bori;
                $grDetail->save();
            }
        }
        $sale->salesItemsDetails()->delete();
        $sale->delete();


        return redirect()->route('sales.list')->with('success', 'Sale deleted successfully');
    }

    public function getItemsByTruck($truckId)
    {
        $items = GoodReceiptDetail::where('truck_id', $truckId)->pluck('goods_name', 'id_grd')->toArray();
        $markas = GoodReceiptDetail::where('truck_id', $truckId)->pluck('marka')->unique()->toArray();

        return response()->json([
            'items' => $items,
            'markas' => $markas
        ]);
    }

    public function getItemsByMarka($truckId, $marka)
    {
        $items = GoodReceiptDetail::where('truck_id', $truckId)->where('marka', $marka)->pluck('goods_name', 'id_grd')->toArray();

        return response()->json($items);
    }

    public function getItemDetails(Request $request)
    {
        $marka = $request->input('marka');
        $item = $request->input('item');

        // Fetch the item details based on Marka and Item
        $itemDetails = GoodReceiptDetail::where('marka', $marka)
            ->where('goods_name', $item)
            ->first();

        // echo $itemDetails->bori;

        if ($itemDetails) {
            return response()->json([
                'bori' => $itemDetails->bori,
                'weight' => $itemDetails->weight,
                'rate' => $itemDetails->rate,
            ]);
        }

        return response()->json([], 404);
    }


    public function print($id)
    {
        $dec_id = Crypt::decrypt($id);
        $sales = Sale::with('salesItemsDetails', 'customer')->where('id_sales', $dec_id)->get();
        return view('sales.print', compact('sales'));
    }
}
