<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SupplierSaleOrder extends Model
{
    protected $table = 'suppliers_sale_orders';
    protected $primaryKey = 'id_suppliers_sale_order';

    protected $fillable = [
        'suppliers_id',
        'order_no',
        'order_date',
        'quantity',
        'amount',
        'status',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'suppliers_id');
    }
}

