@extends('layouts.master')

@push('css')
@endpush

@section('content')
<?php //echo "<pre>"; print_r($po_data); exit(); ?>
<style type="text/css">
    .tborder {border: 1px solid black !important;}
    table.customtble tbody tr td{
        padding: 0px 5px 0px 5px;
        /*border:1px solid #000;*/
        font-size: 11px;

    }
    table.customtble thead tr th{
        padding: 0px 5px 0px 5px;
        /*border:1px solid #000;*/
        font-size: 12px;
        font-weight: bold;
    }
    @media print{
        table.customtble thead tr th{
            font-size: 11px;
        }
        table.customtble tbody tr td{
            font-size: 10px;
        }
        body * { visibility: hidden; margin-top: 0px !important;}
        .printableArea, .printableArea *{ visibility: visible !important; }
        table{ border-collapse: collapse;}
        @page {size: landscape}
    }
</style>
<div class="container-fluid">
    <div class="printableArea" id="printableArea">  
        <form id="FormId" class="form-horizontal" method="POST" action="{{ route('saleSummary') }}">   
            {{ csrf_field() }}
            <div class="form-horizontal form-body hidden-print">
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-default">

                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="fromdate" class="col-sm-3 control-label">From Date</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="fromdate" id="fromdate" class="form-control" autocomplete="false" placeholder="dd/mm/yyyy" value="<?php echo date('d-m-Y', strtotime($fromdate)); ?>" />
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="fromdate" class="col-sm-3 control-label">To Date</label>
                                            <div class="col-sm-8">
                                                <input type="text" name="todate" id="todate" class="form-control" autocomplete="false" placeholder="dd/mm/yyyy" value="<?php echo date('d-m-Y', strtotime($todate)); ?>" />
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-1 ">
                                        <button id="submitbutton" type="button" class="btn btn-primary"><i class="fa fa-search"></i> Run</button>
                                    </div>
                                    <div class="col-md-1 col-lg-1 col-sm-1 col-xs-12">
                                        <span class="spin-loader"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">

                    <div class="panel-body">
                        <div class="clearfix">
                            <div class="pull-left ">
                                <!-- <h3 class="logo invoice-logo"><img src='{{asset('plugins/images/'.$business->business_logo)}}' width="200" alt='logo here' /></h3> -->
                            </div>
                        </div>
                        <hr class="hidden">
                        <div class="row">
                            <div class="col-md-12"><h3 class="text-center">Sales Summary</h3></div>
                        </div>
                        <div class="row hidden">
                            <div class="col-md-12">
                                <table style=" width: 100%;" cellspacing="0" id="podetailstbl" class="customtble">
                                    <tr>
                                        <td style="width: 50% ">
                                            <p><strong>From </strong>: <span id="fromdateshow"><?php echo date('d-M-Y', strtotime($fromdate)); ?></span>
                                                <br>
                                                <strong>To </strong>: <span id="todateshow"><?php echo date('d-M-Y', strtotime($todate)); ?></span>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                            </p>

                                        </td>
                                        <td style="width: 0.5%; border-bottom: none !important; border-top: none !important;"></td>
                                        <td style="width: 50%">
                                            <p><strong>Statement Date: </strong> <?php echo date('d-M-Y'); ?>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                                <br>
                                                <strong></strong> <span id="mode">&nbsp;</span>
                                            </p>

                                        </td>
                                    </tr>
                                </table>

                            </div><!-- end col -->
                        </div>
                        <!-- end row -->

                        <div class="m-h-50">&nbsp;</div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <!-- <table class="table table-bordered m-t-30" id="tblproducts"> -->
                                    <table id="tblreport" class="table-bordered display nowrap" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th class="text-center">Customer Name</th>
                                                <th class="text-center">Qty</th>
                                                <th class="text-center">Return Qty</th>
                                                <th class="text-center">Return Amount</th>
                                                <th class="text-center">Total</th>
                                                <th>Grand Total</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody><tr><td>Data not found</td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <div class="hidden-print">
                            <div class="pull-right">
                                <a id="printbutton" href="#" class="btn btn-inverse waves-effect waves-light hidden" onclick='window.print();'  ><i class="fa fa-print"></i></a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>    
    <!-- end row -->
</div>
<script>
    $(document).ready(function(){
        $('#fromdate').datepicker({
                autoclose: true,
                todayHighlight: true,
                format: "dd-mm-yyyy",
//                viewMode: "months", 
//                minViewMode: "months"
        });

        $('#todate').datepicker({
            autoclose: true,
            todayHighlight: true,
            format: "dd-mm-yyyy",
        });
        
        $('#tblreport').DataTable({
            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
//                            stateSave: true, 
            fixedHeader: {header: true},
            "bSort" : false,
            dom: "Bfrtlip",
            buttons: [
                {extend: "excel", title: 'Sale Summary', filename: 'saleSummary'}, 
//                                {extend: "pdf", title: 'Sale Summary', orientation: 'landscape'}
            ],
            responsive: !0
        });
        
        $('#submitbutton').click(function(){
            $('.spin-loader').addClass('fa fa-spin fa-spinner');
            $('#fromdateshow').html('').html($('#fromdate').val());
            $('#todateshow').html('').html($('#todate').val());
            $.ajax({
                type: 'POST',
                url: $('#FormId').attr('action'),
                data: {fromdate: $('#fromdate').val(), todate: $('#todate').val()},
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo csrf_token(); ?>'
                },
                success: function(response){
                    var data = response;
                    var body = '', total = 0.00, grand_total = 0.00, total_delivered = 0.00, total_returned = 0.00, returned_amount = 0.00;
                    var hhtml = '<tr><th>#</th><th class="text-center">Customer Name</th><th>Qty</th><th>Return Qty</th><th class="text-center">Return Amount</th><th class="text-center">Total</th><th class="text-center">Grand Total</th><th></th></tr>';
                    for(var i = 0; i < data.length; i++){
                        total += parseFloat(data[i]['total']);
                        grand_total += parseFloat(data[i]['grand_total'])-parseFloat(data[i]['return_total']);
                        total_delivered += parseFloat(data[i]['delivered_qty']);
                        total_returned += parseFloat(data[i]['returned_qty']);
                        returned_amount += parseFloat(data[i]['return_total']);
                        body += '<tr>';
                        body += '<td>'+(i+1)+'</td>';
                        body += '<td>'+data[i]['customer_name']+'</td>';
                        body += '<td class="text-right">'+(data[i]['delivered_qty'])+'</td>';
                        body += '<td class="text-right">'+(data[i]['returned_qty'])+'</td>';
                        body += '<td class="text-right">'+addCommas(data[i]['return_total'].toFixed(2))+'</td>';
                        body += '<td class="text-right">'+addCommas(data[i]['total'])+'</td>';
                        body += '<td class="text-right">'+addCommas((data[i]['grand_total']-data[i]['return_total']))+'</td>';
                        body += '<td class="text-center"><form target="_blank" action="<?php echo url('saleSummaryBrandWise'); ?>" method="post"><input type="hidden" name="customer_id" value='+data[i]['customer_id']+'><input type="hidden" name="from" value='+$('#fromdate').val()+'><input type="hidden" name="to" value='+$('#todate').val()+'><input type="hidden" name="_token" id="csrf-token" value="<?php echo csrf_token() ?>" /><button type"submit" class="btn btn-success btn-xs"><i class="icon-list"></i> Brand Wise</button></form></td>';
                        body += '</tr>';
                    }
                    
                    if(data.length > 0){
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        var heading = '<tr>   <td><strong>Sale Report (Detail)</strong></td>          <td></td>     <td></td>     <td></td>     <td></td>     <td></td>     <td></td>      <td></td>      <td></td>      <td></td>     <td></td>    </tr>';
                        var date = '<tr>   <td></td>       <td><strong>From: </strong>'+$('#fromdate').val()+'<strong> To: </strong>'+$('#todate').val()+'</td>      <td></td>       <td></td>       <td></td>     <td></td>  <td></td>     <td></td>   </tr>';
                        var total_row = '<tr> <td></td>    <td class="text-right"><strong>Total:</strong></td>      <td class="text-right">'+addCommas(total_delivered)+'</td>    <td class="text-right">'+addCommas(total_returned)+'</td>     <td class="text-right">'+addCommas(returned_amount)+'</td>     <td class="text-right">'+addCommas(total)+'</td>   <td class="text-right">'+addCommas(grand_total)+'</td>   <td></td> </tr>';
                        var tbody = date+body+total_row;
                        $("#tblreport").dataTable().fnDestroy();
                        $("#tblreport thead").html('');
                        $("#tblreport tbody").html('');
                        $("#tblreport thead").append(hhtml);
                        $("#tblreport tbody").append(tbody);
                        
                        $('#tblreport').DataTable({
                            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
                            stateSave: true, 
                            fixedHeader: {header: true},
                            "bSort" : false,
                            dom: "Bfrtlip",
                            buttons: [
                                {extend: "excel", title: 'Sale Summary', filename: 'saleSummary'}, 
//                                {extend: "pdf", title: 'Sale Summary', orientation: 'landscape'}
                            ],
                            responsive: !0
                        });
                    }else{
                        $('.spin-loader').removeClass('fa fa-spin fa-spinner');
                        $("#tblreport").dataTable().fnDestroy();
                        $("#tblreport thead").html('');
                        $("#tblreport tbody").html('');
                        $("#tblreport thead").append(hhtml);
                        $("#tblreport tbody").append('<tr> <td>Data not found</td> <td></td>  <td></td>  <td></td>  <td></td>  <td></td> <td></td>  <td></td>  </tr>');
                        $('#printbutton').addClass('hidden');
                        $('#tblreport').DataTable({
                            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
//                            stateSave: true, 
                            fixedHeader: {header: true},
                            "bSort" : false,
                            dom: "Bfrtlip",
                            buttons: [
                                {extend: "excel", title: 'Sale Summary', filename: 'saleSummary'}, 
//                                {extend: "pdf", title: 'Sale Summary', orientation: 'landscape'}
                            ],
                            responsive: !0
                        });
                    }
                }
            });
        });
    });
    function addCommas(nStr)
{
    nStr += '';
    x = nStr.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';
    var rgx = /(\d+)(\d{3})/;
    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + ',' + '$2');
    }
    return x1 + x2;
}
</script>
@endsection

