@extends('layouts.master')
@section('content')

<div class="row">
    <div class="col-md-12">
        <div class="card shadow">
            <div class="card-header text-dark">
                <h3 class="card-title mb-0">Edit Shortcut</h3>
            </div>
            <div class="card-body">
                <form action="{{ route('shortkut.update', $shortkut->id_key) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="mb-3 col-md-4">
                            <label for="nameInput" class="form-label">Name:</label>
                            <input type="text" id="nameInput" name="shortcut_name" class="form-control"
                                value="{{ $shortkut->shortcut_name }}" placeholder="Enter your name" required>
                        </div>
                        <div class="mb-3 col-md-4">
                            <label for="shortcutInputCtrl" class="form-label">Shortcut Input for Ctrl:</label>
                            <input type="text" id="shortcutInputCtrl" name="shortcut_key_1" class="form-control"
                                value="{{ $shortkut->shortcut_key_1 }}" placeholder="Press Ctrl">
                        </div>
                        <div class="mb-3 col-md-4">
                            <label for="shortcutInputAlpha" class="form-label">Shortcut Input for Alphabet:</label>
                            <input type="text" id="shortcutInputAlpha" name="shortcut_key_2" class="form-control"
                                value="{{ $shortkut->shortcut_key_2 }}" placeholder="Press any alphabet">
                        </div>
                    </div>
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('shortkut.index') }}" class="btn btn-secondary">Back</a>
                        <button type="submit" class="btn btn-success">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
