<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CustomerSaleOrder extends Model
{
    protected $table = 'customers_sale_orders';
    protected $primaryKey = 'id_customers_sale_order';

    protected $fillable = [
        'customers_id',
        'order_no',
        'order_date',
        'quantity',
        'amount',
        'status',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customers_id');
    }
}
