<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeAttendance extends Model
{
    
    protected $fillable = [
        'employee_id',
        'date',
        'check_in',
        'check_out',
        'status',
        'notes',
    ];

    protected $casts = [
        'check_in'  => 'datetime',
        'check_out' => 'datetime',
        'date'      => 'date',
    ];


    public function employee()
    {
        return $this->belongsTo(Employees::class, 'employee_id');
    }


    public function getStatusLabelAttribute()
    {
        return match ($this->status) {
            'present'  => '✅ Present',
            'late'     => '⏰ Late',
            'half-day' => '🕛 Half Day',
            'absent'   => '❌ Absent',
            'on_leave' => '🌴 On Leave',
            default    => '❓ Unknown',
        };
    }
}
