<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Cities;
use App\City;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;

class CityController extends Controller
{


    protected string $module = 'Cities';

    public function __construct()
    {
        $module = $this->module;

        $this->middleware("permission:$module list")->only(['index']);
        $this->middleware("permission:$module view")->only(['show']);
        $this->middleware("permission:$module add")->only(['create', 'store']);
        $this->middleware("permission:$module edit")->only(['edit', 'update']);
        $this->middleware("permission:$module delete")->only(['destroy']);
    }
    //     public function __construct()
    //     {
    //         $this->middleware('auth');
    //                $this->middleware(function ($request, $next) {
    //                    $this->role_id = Auth::user()->role_id;
    //                 //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //                 //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //                 $ex = explode('/',$request->path());
    //                 if(count($ex)>=3){
    //                     $sliced = array_slice($ex, 0, -1);

    //                 }else{
    //                     $sliced = $ex;
    //                 }

    //                 $string = implode("/", $sliced);
    // //                 dd($string);
    //                    if (checkConstructor($this->role_id, count($ex)>=3 ? $string.'/': $string) == 1) {
    //                        return $next($request);
    //                    }else if(strpos($request->path(), 'store') !== false){
    //                        return $next($request);
    //                    }else if(strpos($request->path(), 'update') !== false){
    //                        return $next($request);
    //                    } else {
    //                        abort(404);
    //                    }
    //                });
    //     }
    public function index()
    {
        $cities = City::all();
        return view('city.index', compact('cities')); //, compact('cities'));
    }

    public function create()
    {
        return view('city.create');
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'city_name' => 'required|string|max:255',
            'city_name_urdu' => 'nullable|string|max:255',
        ]);

        $city = new City();
        $city->city_name = $validatedData['city_name'];
        $city->city_name_urdu = $validatedData['city_name_urdu'];
        $city->save();

        Session::flash('message', 'City has been added');
        return redirect(url('cities'));
    }

    public function edit($id)
    {
        $city_id = Crypt::decrypt($id);
        $city = City::findOrFail($city_id);
        return view('city.edit', compact('city'));
    }

    public function update(Request $request, $id)
    {
        // dd($request->all());
        $validatedData = $request->validate([
            'city_name' => 'required|string|max:255',
            'city_name_urdu' => 'nullable|string|max:255',
        ]);
        $city_id = Crypt::decrypt($id);
        $city = City::find($city_id);
        $city->city_name = $validatedData['city_name'];
        $city->city_name_urdu = $validatedData['city_name_urdu'];
        $city->save();

        Session::flash('message', 'City has been updated');
        return redirect(url('cities'));
    }

    public function destroy($id)
    {
        $city_id = Crypt::decrypt($id);
        $city = City::findOrFail($city_id);

        if ($city) {
            $city->delete();
            Session::flash('message', 'City has been deleted');
        } else {
            Session::flash('message', 'City not found');
        }

        return redirect(url('cities'));
    }
}
