<?php

namespace App\Http\Controllers;

use App\Invoice;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $invoice= Invoice::all()
        ->join('users as u', 'u.id', 'po.created_by');
        $invoice = DB::table('products_category')
        ->join('users', 'users.id', 'products_category.created_by')
        ->select('products_category.*','users.name')->get();
        return view('invoice_preference.index', compact('invoice'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $invoice= Invoice::all();
        return view('invoice_preference.create', compact('invoice'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $store = new Invoice();
        $store->products_category_name= $request->products_category_name;
        $store->products_category_name_urdu= $request->products_category_name_urdu;
        $store->products_category_status = "1";

        // $store->created_by = auth()->user()->id;
        // dd($store);
        $store->save();

            // session()->flash('success', "New Discounted Added Successfully");

            // return redirect('invoice.list');

            return redirect()->route('invoice.list')->with('success', 'Brand updated successfully!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function show(Invoice $invoice)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
            $edit =Invoice::where('id_products_category' , $dec_id)->first();
            // $edit = currency_exchange_rate::all();

            return view('invoice_preference.edit' , compact('edit'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $dec_id = \Crypt::decrypt($id);
        $update = Invoice::where('id_products_category' , $dec_id)->first();
        $update->products_category_name = $request->products_category_name;
        $update->products_category_name_urdu = $request->products_category_name_urdu;

        $update->products_category_status = "1";
        $update->created_by = auth()->user()->id;
        $update->save();
            // session()->flash('success', " Discounted Updated Successfully");

            // return redirect('invoice.list');
            return redirect()->route('invoice.list')->with('success', 'Brand updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function destroy(Invoice $invoice)
    {
        //
    }
}
