<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServicePurchase extends Model
{
    use HasFactory;

    protected $primaryKey = 'id_ser_purchase';
    protected $table = 'service_purchase';
    protected $fillable = [
        'unit_id',
        'supplier_id',
        'ser_purchase_sp_no',
        'ser_purchase_vechile_no',
        'ser_purchase_bill_no',
        'ser_purchase_expense',
        'ser_purchase_qty',
        'ser_purchase_unit',
        'ser_purchase_price',
        'ser_purchase_amount',
        'ser_purchase_remarks',
        'ser_purchase_status',
        'ser_purchase_date',
        'created_by',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id');
        // return $this->hasMany(Products::class, 'service_purchase_id');
    }
}
