<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupplierBrand extends Model
{
    protected $primaryKey = 'id_supplier_brand';
    protected $table = 'supplier_brand';
    protected $fillable = [
        'brand_id',
        'supplier_id',
    ];

    public function suppliers()
    {
        return $this->belongsTo(Suppliers::class, 'supplier_id');
    }
    public function brands()
    {
        return $this->belongsTo(Brands::class, 'brand_id');
    }
}
