@extends('layouts.master')

@section('title', 'Employee Payrolls')

@section('content')
<div class="az-content-breadcrumb mb-3">
    <span>Payrolls</span>
</div>

<div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
    <h4 class="mb-2 mb-md-0">Employee Payrolls</h4>

    <div class="d-flex flex-wrap gap-2">

        <form action="{{ route('payroll.generate') }}" method="POST" style="border-right: 1px solid black; padding-right: 8px ;"  class="d-flex  align-items-center gap-2">
            @csrf
            <input type="month" name="month_year" class="form-control" value="{{ now()->format('Y-m') }}">
            <button class="btn btn-success shadow-sm">
                <i class="fas fa-file-invoice-dollar me-1"></i> Generate Payroll
            </button>
        </form>


        <form action="{{ route('payroll.payall') }}" method="POST"  class="d-flex align-items-center gap-2">
            @csrf
            <input type="month" name="month_year" class="form-control" value="{{ now()->format('Y-m') }}">
            <button class="btn btn-success shadow-sm">
                <i class="fas fa-money-bill-wave me-1"></i> Pay All
            </button>
        </form>
    </div>
</div>

{{-- Success / Error Messages --}}
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

<div class="card shadow border-0">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-striped align-middle text-center" id="payrollTable">
                <thead class="bg-dark text-white">
                    <tr>
                        <th>Employee</th>
                        <th>Month</th>
                        <th>Gross Salary</th>
                        <th>Deductions</th>
                        <th>Net Salary</th>
                        <th>Late Days</th>
                        <th>Absent Days</th>
                        <th>Status</th>
                        <th>Paid At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($payrolls as $pay)
                        @php
                            $attendances = $pay->employee->attendances()
                                ->whereYear('date', $pay->year)
                                ->whereMonth('date', $pay->month)
                                ->get();
                            $lateDays = $attendances->where('status', 'late')->count();
                            $absentDays = $attendances->where('status', 'absent')->count();
                        @endphp
                        <tr class="hover-zoom">
                            <td>{{ $pay->employee->first_name }} {{ $pay->employee->last_name }}</td>
                            <td>{{ \Carbon\Carbon::create($pay->year, $pay->month)->format('F, Y') }}</td>
                            <td>{{ number_format($pay->gross_salary, 2) }}</td>
                            <td>{{ number_format($pay->deductions, 2) }}</td>
                            <td>{{ number_format($pay->net_salary, 2) }}</td>
                            <td>
                                <span class="badge bg-warning text-dark">{{ $lateDays }}</span>
                            </td>
                            <td>
                                <span class="badge bg-danger">{{ $absentDays }}</span>
                            </td>
                            <td>
                                <span class="badge {{ $pay->status=='paid' ? 'bg-success' : 'bg-secondary text-dark' }}">
                                    {{ ucfirst($pay->status) }}
                                </span>
                            </td>
                            <td>{{ $pay->paid_at ? \Carbon\Carbon::parse($pay->paid_at)->format('d-m-Y') : '-' }}</td>
                            <td>
                                @if($pay->status == 'unpaid')
                                    <form action="{{ route('payroll.pay', $pay->id) }}" method="POST">
                                        @csrf
                                        <button class="btn btn-success btn-sm">
                                            <i class="fas fa-dollar-sign me-1"></i> Pay
                                        </button>
                                    </form>
                                @else
                                    <span class="badge bg-success">Paid</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .hover-zoom:hover {
        transform: scale(1.02);
        transition: 0.2s ease-in-out;
    }
    .table th {
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .badge {
        font-size: 0.85rem;
    }
    .form-control {
        min-width: 150px;
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        $('#payrollTable').DataTable({
            dom: 'Bfrtip',
            buttons: ['csv', 'excel', 'pdf', 'print'],
            responsive: true,
            order: [[1, 'desc']],
            pageLength: 25
        });
    });
</script>
@endpush
