@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Notification Management</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Notification Management <span>
            @can('Notifications Management add')
                <a href="{{ route('notification.create') }}" class="btn btn-az-primary" style="float: right">Add Notification
                    Management</a>
            @endcan
        </span></h2>
    {{-- <h2 style="float: right" class="az-content-title"></h2> --}}


    {{-- <div class="az-content-body pd-lg-l-40 d-flex flex-column"> --}}
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            {{-- <div class="card card-body pd-40"> --}}

            <div>
                <table id="example2" class="table table-striped">
                    <thead>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Notification Management Name</th>
                            <th class="wd-10p">Product Category(Urdu)</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created By</th>
                            <th class="wd-10p">Created</th>
                            <th class="col-2">Operations</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($notification as $key => $discount)
                            <tr>

                                <td>{{ $key + 1 }}</td>
                                {{-- <td>{{ $discount->discount_name }}</td>
                               <td>{{ $discount->discount_type }}</td> --}}
                                <td>{{ $discount->discount_for }}</td>
                                <td>{{ $discount->discount_price }}</td>
                                <td>{{ $discount->discount_status }}</td>
                                <td>{{ $discount->name }}</td>
                                <td><?= date('d-m-Y', strtotime($discount->created_at)) ?></td>
                                <td>
                                    @can('Notifications Management edit')
                                        <a class="btn btn-rounded btn-primary"
                                            href="{{ route('notification.edit', \Crypt::encrypt($discount->id_discounts)) }}">
                                            Edit
                                        </a>
                                    @endcan
                                    @can('Notifications Management delete')
                                        <a class="btn btn-rounded btn-danger"
                                            href="{{ route('notification.destroy', \Crypt::encrypt($discount->id_discounts)) }}">
                                            Delete
                                        </a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th class="wd-10p">S.No</th>
                            <th class="wd-10p">Notification Management Name</th>
                            <th class="wd-10p">Product Category(Urdu)</th>
                            <th class="wd-10p">Status</th>
                            <th class="wd-10p">Created By</th>
                            <th class="wd-10p">Created</th>
                            <th class="col-2">Operations</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            {{-- </div> --}}
            <!-- card -->
        </div>
        <!-- col -->
    </div>






    {{-- </div><!-- az-content-body --> --}}
@endsection

@push('scripts')
    <script type="text/javascript">
        $(function() {



            oTable = $('#example2').DataTable({

                responsive: !0
            });



        });
    </script>
@endpush
