@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Print Preference</span>
        <span>Add Print Preference</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> New Print Preference <span>


        <a href="{{ route('printPreference.index') }}" class="btn border" style="float: right">
            <i class="fa-solid fa-bars-staggered"></i> Back to Print Preference
        </a>

            </a>
        </span></h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Print Preference</h5>
                <form id="myForm" method="post" action="{{ route('printPreference.store') }}" enctype="multipart/form-data">

                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600"> Name </label>
                                <input type="text" name="type" class="form-control"
                                    value="{{ old('type') }}" required />
                            </div>
                        </div>

                    </div>
                    <a type="button" href="{{ url('/list') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
            <!-- card -->
        </div>
        <!-- col -->
    </div>
@endsection
@push('scripts')
    <script>
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();

                document.getElementById('myForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });
    </script>
@endpush
