<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Vouchers</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f8f9fa;
        }

        .voucher-container {
            max-width: 800px;
            margin: auto;
            background-color: white;
            padding: 20px;
            border: 1px solid #ccc;
            margin-bottom: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .voucher-header {
            text-align: center;
            margin-bottom: 20px;
        }

        .voucher-header h4 {
            margin: 0;
            font-weight: bold;
        }

        .voucher-header h5 {
            margin: 0;
            margin-top: 5px;
            font-weight: normal;
            font-size: 1.1rem;
            color: #666;
        }

        .voucher-details {
            margin-bottom: 20px;
        }

        .voucher-details td {
            padding: 5px;
        }

        .voucher-details strong {
            font-weight: bold;
        }

        .voucher-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }

        .voucher-table th,
        .voucher-table td {
            padding: 8px;
            border: 1px solid #ccc;
            text-align: right;
        }

        .voucher-table th {
            background-color: #f1f1f1;
            text-align: left;
        }

        .text-left {
            text-align: left;
        }

        .total {
            font-weight: bold;
            font-size: 1.2rem;
        }

        .voucher-footer {
            margin-top: 20px;
            display: flex;
            justify-content: space-between;
            text-align: center;
        }

        .voucher-footer div {
            width: 150px;
            border-top: 1px solid #000;
            padding-top: 10px;
        }

        .print-info {
            margin-top: 20px;
            text-align: center;
            font-size: 0.9rem;
            color: #666;
        }
    </style>
</head>

<body>

    <!-- Cash Payment Voucher -->
    <div class="voucher-container">
        <div class="voucher-header">
            <h4>M.D.S</h4>
            <h5>CASH PAYMENT VOUCHER</h5>
        </div>

        <div class="voucher-details">
            <table class="table table-borderless">
                <tr>
                    <td>User: <strong>FAHAD</strong></td>
                    <td>No.: <strong>10188</strong></td>
                </tr>
                <tr>
                    <td>Entry Date & Time: <strong>09/09/2024 02:09 PM</strong></td>
                    <td>Dated: <strong>09/09/2024</strong></td>
                </tr>
            </table>
            <div class="mb-3 d-flex justify-content-between">
                <div><strong>Slip No:</strong> <span class="border-bottom d-inline-block w-100"></span></div>
                <div><strong>Invoice No:</strong> <span class="border-bottom d-inline-block w-100"></span></div>
            </div>
        </div>

        <table class="voucher-table table table-bordered">
            <thead>
                <tr>
                    <th class="text-left">نمبر</th>
                    <th class="text-left">کوڈ</th>
                    <th class="text-left">تفصیل</th>
                    <th class="text-right">رقم</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>30-00-20-0001</td>
                    <td class="text-left">کراچی</td>
                    <td>1,900,000</td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>20-02-30-0112</td>
                    <td class="text-left">MDS COMPANY</td>
                    <td>550,000</td>
                </tr>
                <tr>
                    <td>3</td>
                    <td>50-00-30-0009</td>
                    <td class="text-left">MISCLENSE ACCOUNT</td>
                    <td>200,000</td>
                </tr>
                <tr>
                    <td>4</td>
                    <td>30-00-30-0108</td>
                    <td class="text-left">___________________</td>
                    <td>144,405</td>
                </tr>
                <tr>
                    <td>5</td>
                    <td>30-00-30-0033</td>
                    <td class="text-left">___________________</td>
                    <td>135,625</td>
                </tr>
                <tr>
                    <td>6</td>
                    <td>30-00-30-0108</td>
                    <td class="text-left">___________________</td>
                    <td>100,000</td>
                </tr>
                <tr>
                    <td>7</td>
                    <td>20-02-30-0117</td>
                    <td class="text-left">___________________</td>
                    <td>64,650</td>
                </tr>
                <tr>
                    <td>8</td>
                    <td>50-00-40-0027</td>
                    <td class="text-left">___________________</td>
                    <td>20,000</td>
                </tr>
                <tr>
                    <td>9</td>
                    <td>20-02-30-0117</td>
                    <td class="text-left">___________________</td>
                    <td>19,800</td>
                </tr>
                <tr>
                    <td>10</td>
                    <td>50-00-40-0001</td>
                    <td class="text-left">___________________</td>
                    <td>16,000</td>
                </tr>
                <tr>
                    <td>11</td>
                    <td>10-00-10-0003</td>
                    <td class="text-left">___________________</td>
                    <td>15,400</td>
                </tr>
            </tbody>
        </table>

        <div class="text-right total">
            Total: ___________________
        </div>

        <div class="voucher-footer">
            <div>Checked By</div>
            <div>Manager</div>
            <div>Approved By</div>
            <div>Received By</div>
        </div>

        <div class="print-info">
            Print Date & Time: 09/09/2024
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
