@extends('layouts.master')

@section('content')
    <div class="az-content-breadcrumb">
        <span>Suppliers Brand</span>
        <span>Add Brand</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Add New Brand
        <span>
            <a href="{{ route('supplier.brand', \Crypt::encrypt($supplierId)) }}" class="btn border" style="float: right">
                <i class="fa-solid fa-bars-staggered"></i>
                Back to Brands
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Insert Brand Details</h5>
                <form method="post" action="{{ route('supplier.brand_store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Supplier Name</label>
                                <select class="form-control" name="supplier_display" id="" disabled
                                    style="display: block; color: #000;">
                                    <option value="{{ $supplier->id_supplier }}">{{ $supplier->supplier_name }}</option>
                                </select>
                                <input type="hidden" name="supplier" value="{{ $supplier->id_supplier }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="az-content-label tx-11 tx-medium tx-gray-600">Brand</label>
                                {{-- <select class="form-control select2" name="brand" id="brandSelect" multiple>
                                    <option value="">Select Brand</option>
                                    @foreach ($brands as $brand)
                                        <option value="{{ $brand->id_brands }}">{{ $brand->brands_name }}</option>
                                    @endforeach
                                </select> --}}
                                <select class="form-control select2" name="brand[]" id="brandSelect" multiple>
                                    <option value="">Select Brand</option>
                                    @foreach ($brands as $brand)
                                        <option value="{{ $brand->id_brands }}">{{ $brand->brands_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <a type="button" href="{{ route('supplier.list') }}" class="btn btn-danger btn-block mt-2">
                        Cancel
                    </a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">
                        Submit
                    </button>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('#brandSelect').select2({
                theme: 'default',
                placeholder: 'Select Brand(s)',
            });
        });
    </script>
@endpush
