<!DOCTYPE html>
<html>

<head>
    <title>Receivables - Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .container {
            width: 95%;
            margin: auto;
        }

        h2,
        p {
            text-align: center;
        }

        .columns {
            display: flex;
            gap: 20px;
        }

        .col {
            width: 50%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th,
        td {
            padding: 6px;
            border: 2px solid black;
            text-align: right;
        }

        .no-print {
            margin-top: 20px;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>M.D.S</h2>
        <p>Receivables &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; وصولی ادھاری</p>
        <p>As At {{ date('M d , y') }}</p>

        @php
            $half = ceil($sales->count() / 2);
            $firstPart = $sales->slice($half);
            $secondPart = $sales->slice(0, $half);
        @endphp

        <div class="columns">
            {{-- LEFT --}}
            <div class="col">
                @php
                    $leftTodayTotal = 0;
                    $leftPaidTotal = 0;
                    $leftBalanceTotal = 0;
                @endphp
                <table>
                    <thead>
                        <tr>
                            <th>وصولی</th>
                            <th>فروخت وغیرہ</th>
                            <th>سابِقہ بیلنس</th>
                            <th>پارٹی</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($firstPart as $sale)
                            @php
                                $leftPaidTotal += $sale->total_paid_amount;
                                $leftTodayTotal += $sale->today_balance;
                                $leftBalanceTotal += $sale->adjusted_balance;
                            @endphp
                            <tr>
                                <td>{{ number_format($sale->total_paid_amount, 0) }}</td>
                                <td>{{ number_format($sale->today_balance, 0) }}</td>
                                <td>{{ number_format($sale->adjusted_balance, 0) }}</td>
                                <td>{{ $sale->customer?->customer_name_urdu }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="font-weight:bold;background:#f0f0f0;">
                            <td>{{ number_format($leftPaidTotal, 0) }}</td>
                            <td>{{ number_format($leftTodayTotal, 0) }}</td>
                            <td>{{ number_format($leftBalanceTotal, 0) }}</td>
                            <td>ٹوٹل</td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            {{-- RIGHT --}}
            <div class="col">
                @php
                    $rightTodayTotal = 0;
                    $rightPaidTotal = 0;
                    $rightBalanceTotal = 0;
                @endphp
                <table>
                    <thead>
                        <tr>
                            <th>وصولی</th>
                            <th>فروخت وغیرہ</th>
                            <th>سابِقہ بیلنس</th>
                            <th>پارٹی</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($secondPart as $sale)
                            @php
                                $rightPaidTotal += $sale->total_paid_amount;
                                $rightTodayTotal += $sale->today_balance;
                                $rightBalanceTotal += $sale->adjusted_balance;
                            @endphp
                            <tr>
                                <td>{{ number_format($sale->total_paid_amount, 0) }}</td>
                                <td>{{ number_format($sale->today_balance, 0) }}</td>
                                <td>{{ number_format($sale->adjusted_balance, 0) }}</td>
                                <td>{{ $sale->customer?->customer_name_urdu }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr style="font-weight:bold;background:#f0f0f0;">
                            <td>{{ number_format($rightPaidTotal, 0) }}</td>
                            <td>{{ number_format($rightTodayTotal, 0) }}</td>
                            <td>{{ number_format($rightBalanceTotal, 0) }}</td>
                            <td>ٹوٹل</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <button class="no-print" onclick="window.print()">Print</button>
    </div>
</body>

</html>
