<!DOCTYPE html>
<html lang="en" dir="rtl">

<head>
    <meta charset="UTF-8">
    <title>Sale Register - Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 95%;
            margin: auto;
        }

        h2,
        p {
            text-align: center;
        }

        /* Columns layout */
        .columns {
            display: flex;
            gap: 20px;
            margin-top: 20px;
        }

        tr.customer-end td:not(:first-child):not(:nth-child(2)) {
            border-bottom: 1px dashed #000;
        }

        .col {
            width: 100%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }


        td {
            padding: 8px;
            /* border: 1px solid #000; */
            text-align: center;
        }

        th {
            padding: 8px;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
            text-align: center;

        }

        /* Grand Total Row Styling */
        tr.grand-total {
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            font-weight: bold;
            background-color: #f0f0f0;
        }

        tr.grand-total td {
            padding: 12px 8px;
        }

        .no-print {
            display: block;
            margin: 20px auto;
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>M.D.S</h2>
        <p>Sales Register &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; فروخت رجسٹر</p>
        <p>As At {{ date('M d, Y') }}</p>

        <div class="columns">
            <!-- LEFT SIDE -->
            <div class="col">
                <table>
                    <thead>
                        <tr>
                            <th></th>
                            <th>مال</th>
                            <th>بوری</th>
                            <th>وزن</th>
                            <th>ریٹ</th>
                            <th>قیمت</th>
                            <th>کیش وصول</th>
                            <th>باقیہ</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($salesByCustomer as $customerId => $customerSales)
                            @php
                                $total_bori = 0;
                                $total_weight = 0;
                                $total_rate = 0;
                            @endphp
                            <tr>
                                <td>
                                    <h3>{{ $customerSales->first()->customer->customer_name_urdu ?? 'Unknown Customer' }}
                                    </h3>
                                    </th>
                            </tr>

                            @foreach ($customerSales as $sale)
                                @foreach ($sale->salesItemsDetails as $item)
                                    @php
                                        $total_bori += (int) $item->bori;
                                        $total_weight += (int) $item->weight;
                                        $total_rate += (int) $item->rate;
                                    @endphp
                                    <tr class="{{ $loop->last && $loop->parent->last ? 'customer-end' : '' }}">
                                        <td></td>
                                        <td>{{ $item->productChildCate->name_urdu ?? null }}</td>
                                        <td>{{ $item->bori }}</td>
                                        <td>{{ $item->weight }}</td>
                                        <td>{{ $item->rate }}</td>
                                        <td>{{ $item->amount }}</td>
                                        <td></td>
                                        <td></td>

                                    </tr>
                                @endforeach
                            @endforeach
                            <tr class="">
                                <td colspan="2" style="text-align:right; font-weight:bold;"></td>
                                <td>
                                    {{ $total_bori }}
                                </td>
                                <td>{{ $total_weight }}
                                </td>
                                <td>{{ $total_rate }}</td>
                                <td>{{ $customerSales->sum(fn($sale) => $sale->salesItemsDetails->sum(fn($i) => $i->amount)) }}
                                </td>
                                <td>{{ $customerTotals[$customerId]['total_paid'] ?? 0 }}</td>
                                <td>{{ $customerTotals[$customerId]['total_balance'] ?? 0 }}</td>
                            </tr>
                        @endforeach

                        <!-- GRAND TOTAL ROW -->
                        <tr class="grand-total">
                            <td colspan="2" style="text-align:right;">کل جمع (Grand Total)</td>
                            <td>{{ number_format(
                                $salesByCustomer->flatMap(fn($customerSales) => $customerSales->flatMap(fn($sale) => $sale->salesItemsDetails))->sum('bori'),
                            ) }}
                            </td>

                            <td>{{ number_format(
                                $salesByCustomer->flatMap(fn($customerSales) => $customerSales->flatMap(fn($sale) => $sale->salesItemsDetails))->sum('weight'),
                            ) }}
                            </td>

                            <td>{{ number_format(
                                $salesByCustomer->flatMap(fn($customerSales) => $customerSales->flatMap(fn($sale) => $sale->salesItemsDetails))->sum('rate'),
                            ) }}
                            </td>

                            <td>{{ number_format(
                                $salesByCustomer->flatMap(fn($customerSales) => $customerSales->flatMap(fn($sale) => $sale->salesItemsDetails))->sum('amount'),
                            ) }}
                            </td>

                            <td>{{ number_format(collect($customerTotals)->sum('total_paid')) }}</td>

                            <td>{{ number_format(collect($customerTotals)->sum('total_balance')) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- RIGHT SIDE (optional) -->

        </div>

        <button class="no-print" onclick="window.print()">Print</button>
    </div>
</body>

</html>
