<!DOCTYPE html>
<html>

<head>
    <title>Stock In Hand Register - Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .container {
            width: 95%;
            margin: auto;
        }

        h2,
        p {
            text-align: center;
        }

        /* 2 Columns */
        .columns {
            display: flex;
            gap: 20px;
        }

        .col {
            width: 100%;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        th
         {
            padding: 6px;
            border-top: 2px solid black;
            border-bottom: 2px solid black;
            text-align: right;
        }
          td
         {
            padding: 6px;
            border-top: 2px dashed black;
            border-bottom: 2px dashed black;
            text-align: right;
        }

        .no-print {
            margin-top: 20px;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>M.D.S</h2>
        <p>Stock In Hand Register &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;مال اسٹاک</p>
        <p>Balance Stock</p>



        <div class="columns">
            <div class="col">
                <table>
                    <thead>
                        <tr>
                            <th>بقایہ</th>
                            <th>فروخت</th>
                            <th>وصول بوریاں</th>
                            <th>مارکہ</th>
                            <th>مال</th>
                            <th>سپلائر</th>
                            <th>گاڑی نمبر</th>
                            <th>بلٹی نمبر</th>
                            <th>تاریخ</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- {{ dd($salesByCustomer) }} --}}
                        @foreach ($stockHand as $stock)
                            <tr>
                                @php
                                    $totalBori = $stock->salesItemDetail->sum('bori');
                                @endphp
                                <td>{{ $stock->total_bori - $totalBori }}</td>
                                <td>{{ $totalBori }}</td>
                                <td>{{ $stock->total_bori }}</td>
                                <td>{{ $stock->marka }}</td>
                                <td>{{ $stock->productChildCate->name_urdu }}</td>
                                <td>{{ $stock->goodReceipt->supplier->supplier_name_urdu }}</td>
                                <td>{{ $stock->goodReceiptTruck->truck_no }}</td>
                                <td>{{ $stock->goodReceipt->builty_no }}</td>
                                <td>{{ $stock->goodReceipt->date }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>

        <button class="no-print" onclick="window.print()">Print</button>
    </div>

</body>

</html>
