@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Service Purchase</span>
        <span>Add Service Purchase</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Add New Service Purchase
        <span>
            <a href="{{ route('service_purchase.list') }}" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to Service Purchase
            </a>
        </span>
    </h2>
    <div class="separator-breadcrumb border-top"></div>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Service Purchase Details</h5>
                @if (Session('alert'))
                    <div class="alert alert-card alert-<?php echo Session('alert-class'); ?>" role="alert">
                        <?php echo Session('alert'); ?>
                        <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                    </div>
                @endif
                <form action="{{ route('service_purchase.store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Unit Id</label>
                                    <input name="unit_id" id="unit_id" class="form-control"
                                        value="{{ old('unit_id') }}" />
                                    @error('unit_id')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Sp No</label>
                                    <input name="ser_purchase_sp_no" id="ser_purchase_sp_no" class="form-control" />
                                    @error('ser_purchase_sp_no')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Vechile No</label>
                                    <input name="ser_purchase_vechile_no" id="ser_purchase_vechile_no" class="form-control"
                                        value="{{ old('ser_purchase_vechile_no') }}" />
                                    @error('ser_purchase_vechile_no')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Bill No</label>
                                    <input name="ser_purchase_bill_no" id="ser_purchase_bill_no" class="form-control" />
                                    @error('ser_purchase_bill_no')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Expense</label>
                                    <input name="ser_purchase_expense" id="ser_purchase_expense" class="form-control"
                                        value="{{ old('ser_purchase_expense') }}" />
                                    @error('ser_purchase_expense')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Qty</label>
                                    <input name="ser_purchase_qty" id="ser_purchase_qty" class="form-control" />
                                    @error('ser_purchase_qty')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                     <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Unit</label>
                                    <input name="ser_purchase_unit" id="ser_purchase_unit" class="form-control"
                                        value="{{ old('ser_purchase_unit') }}" />
                                    @error('ser_purchase_unit')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Price</label>
                                    <input name="ser_purchase_price" id="ser_purchase_price" class="form-control" />
                                    @error('ser_purchase_price')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Amount</label>
                                    <input name="ser_purchase_amount" id="ser_purchase_unit" class="form-control"
                                        value="{{ old('ser_purchase_amount') }}" />
                                    @error('ser_purchase_amount')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600">Remarks</label>
                                    <input name="ser_purchase_remarks" id="ser_purchase_remarks" class="form-control" />
                                    @error('ser_purchase_remarks')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600" for="supplier_id">Supplier
                                        Id</label>
                                    <input name="supplier_id" id="supplier_id" class="form-control"
                                        value="{{ old('supplier_id') }}" />
                                    @error('supplier_id')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row-sm mg-b-20">
                                <div class="form-group">
                                    <label class="az-content-label tx-11 tx-medium tx-gray-600"
                                        for="ser_purchase_status">Status</label>
                                    <select id="ser_purchase_status" name="ser_purchase_status" class="form-control">
                                        <option value="">Select</option>
                                        <option value="1" {{ old('ser_purchase_status') == '1' ? 'selected' : '' }}>
                                            Active
                                        </option>
                                        <option value="0" {{ old('ser_purchase_status') == '0' ? 'selected' : '' }}>
                                            In-Active
                                        </option>
                                    </select>
                                    @error('ser_purchase_status')
                                        <span class="form-text text-muted">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
            </div>



            <button type="button" onclick="history.back()" class="btn btn-danger btn-block mt-2">Cancel</button>
            <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Submit</button>
            </form>
        </div>
    </div>
    </div><!-- end of main-content -->
    <script src="https://cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
    <script></script>
@endsection
