@extends('layouts.master')
@section('content')

    <div class="az-content-breadcrumb">
        <span>Supplier</span>
        <span>Add Supplier </span>
    </div>
    <h2 class="az-content-title" style="display: inline">Add New Supplier
        <span>
            <a href="{{ route('supplier.list') }}" class="btn border" style="float: right"><i
                    class="fa-solid fa-bars-staggered"></i>
                Back to Supplier
            </a>
        </span>
    </h2>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-40">
                <h5 class="card-title mg-b-20">Add Supplier</h5>
                <hr>
                <form method="post" id="myForm" action="{{ route('supplier.store') }}">
                    @csrf
                    @if (count($errors) > 0)
                        <div class="p-1">
                            @foreach ($errors->all() as $error)
                                <div class="alert alert-warning alert-danger fade show" role="alert">{{ $error }}
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            @endforeach
                        </div>
                    @endif

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Opening Balance Date</label>
                                <input type="text" id="opening_date" name="opening_date" class="form-control"
                                    placeholder="dd/mm/yyyy" value="{{ old('opening_date') }}" readonly />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Supplier Name (English) <span style="color:red;">*</span></label>
                                <input type="text" name="supplier_name" class="form-control"
                                    value="{{ old('supplier_name') }}" required />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="" style="float: inline-end;"> کھا تہ </label>
                                <input type="text" name="supplier_name_urdu" class="form-control" id="supplier_name_urdu"
                                    value="{{ old('supplier_name_urdu') }}" />
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Email</label>
                                <input type="email" name="email" class="form-control" value="{{ old('email') }}" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Contact Person</label>
                                <input type="text" name="contact_person" class="form-control"
                                    value="{{ old('contact_person') }}" />
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">Address (English)</label>
                                <input type="text" name="address" class="form-control" value="{{ old('address') }}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="" style="float: inline-end;"> گاہک کا پتہ </label>
                                <input type="text" name="supplier_address_urdu" class="form-control"
                                    id="supplier_address_urdu" value="{{ old('supplier_address_urdu') }}" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="">City</label>
                                <select class="form-control" name="city" id="city">
                                    @foreach ($cities as $key => $city)
                                        <option value="{{ $city->id_city }}">
                                            {{ $city->city_name }} | {{ $city->city_name_urdu }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Phone 1</label>
                                <input type="text" name="phone_1" class="form-control" value="{{ old('phone_1') }}" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Phone 2</label>
                                <input type="text" name="phone_2" class="form-control"
                                    value="{{ old('phone_2') }}" />
                            </div>
                        </div>
                    </div>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Website</label>
                                <input type="text" name="website" class="form-control"
                                    value="{{ old('website') }}" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Status</label>
                                <select class="form-control" name="status" id="status">
                                    <option>- Select -</option>
                                    <option value="0" {{ old('status') == '0' ? 'selected' : 'selected' }}>Active
                                    </option>
                                    <option value="1" {{ old('status') == '1' ? 'selected' : '' }}>In Active</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <h5 class="card-title mg-b-20">Add Supplier</h5>
                    <hr>

                    <div class="row row-sm mg-b-20">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Opening Balance Debit</label>
                                <input oninput="formatWithCommas(this)" type="text" name="blance_dr"
                                    class="form-control" value="{{ old('blance_dr') }}" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="">Opening Balance Credit</label>
                                <input oninput="formatWithCommas(this)" type="text" name="blance_cr"
                                    class="form-control" value="{{ old('blance_cr') }}" />
                            </div>
                        </div>
                    </div>

                    <a href="{{ route('supplier.list') }}" class="btn btn-danger btn-block mt-2">Cancel</a>
                    <button type="submit" class="btn btn-az-primary btn-block mt-2" style="float: right">Submit</button>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // $(document).ready(function() {
        //     $("#opening_date").datepicker({
        //         dateFormat: "yy-mm-dd" // You can customize the date format here
        //     });
        // });
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();
 
                document.getElementById('myForm').submit();
            }

            if (event.key === 'Enter') {
                event.preventDefault();
            }
        });

        $(document).ready(function() {
            // Set the default date to today
            var today = new Date();
            var formattedDate = today.getFullYear() + '-' + ('0' + (today.getMonth() + 1)).slice(-2) + '-' + ('0' +
                today.getDate()).slice(-2);

            $("#opening_date").val(formattedDate);

            // Initialize datepicker with custom format
            $("#opening_date").datepicker({
                dateFormat: "yy-mm-dd" // Customize the date format here
            });

            $('#city').select2({
                theme: 'default'
            });
        });


        // document.getElementById('supplier_name_urdu').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;

        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });

        // document.getElementById('supplier_address_urdu').addEventListener('input', function(e) {
        //     var urduPattern = /[\u0600-\u06FF\u0750-\u077F ]/g;
        //     var inputValue = e.target.value;

        //     e.target.value = inputValue.replace(/[^\u0600-\u06FF\u0750-\u077F ]/g, '');
        // });
    </script>
@endpush
