<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SalesItemDetail extends Model
{
    protected $primaryKey = 'id_sid';
    protected $table = 'sales_items_details';
    protected $fillable = [
        'sales_id',
        'good_detail_id',
        'items_name',
        'items_main_cate',
        'items_parent_cate',
        'items_child_cate',
        'marka',
        'bori',
        'weight',
        'rate',
        'amount',
        'notes',
        'status',
        'rate_applied_on',
    ];

    public function sale()
    {
        return $this->belongsTo(Sale::class, 'sales_id');
    }


    // Relationship with ProductsCategoryMain
    public function productMainCate()
    {
        return $this->belongsTo(ProductsCategoryMain::class, 'items_main_cate', 'id_pro_cate_main');
    }

    // Relationship with ProductsSubCategoryParent
    public function productParentCate()
    {
        return $this->belongsTo(ProductsSubCategoryParent::class, 'items_parent_cate', 'id_pro_sub_cat_parent');
    }

    // Relationship with ProductsSubCategoryChild
    public function productChildCate()
    {
        return $this->belongsTo(ProductsSubCategoryChild::class, 'items_child_cate', 'id_pro_sub_cat_child');
    }
    public function goodReceiptDetail()
    {
        return $this->belongsTo(GoodReceiptDetail::class, 'good_detail_id');
    }
    // public function salesPerBoriWeight()
    // {
    //     return $this->hasMany(SalesPerBoriWeight::class, 'sales_items_details_id');
    // }
    private function cleanDecimal($value)
    {

     return   $trim = rtrim(rtrim($value, '0'), '.');
        // return number_format($trim);
    }

    public function getRateAttribute($value)
    {

        return $this->cleanDecimal($value);
    }
    public function getAmountAttribute($value)
    {
        // dd($value);
        return $this->cleanDecimal($value);
    }
}
