<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Voucher extends Model
{
    //    use HasFactory;
    protected $table = 'vouchers';
    protected $primaryKey = 'id_vouchers';
    protected $fillable = [
        'vouchers_unique_number_id',
        'voucher_date',
        'payment_mode',
        'account',
        'voucher_details',
        'voucher_giver',
        'voucher_invno',
        'voucher_chqno',
        'voucher_chqdate',
        'voucher_depdate',
        'voucher_depslipno',
        'transaction_type',
        'cheq_status',
        'voucher_hondate',
        'voucher_dishondate',
        'net_amount',
        'adaegi_array',
        'status'
    ];

    /**
     * Get the unique voucher number associated with this voucher.
     */
    public function uniqueNumber()
    {
        return $this->belongsTo(VouchersUniqueNumber::class, 'vouchers_unique_number_id');
    }
    // public function vouchersUniqueNumber()
    // {
    //     return $this->belongsTo(VouchersUniqueNumber::class, 'vouchers_unique_number_id');
    // }
    public function accounts_permissions()
    {
        return $this->belongsTo(AccountsPermissions::class, 'account_title', 'account_name');
    }
}
