<?php

namespace App;

//use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VouchersUniqueNumber extends Model
{
    //    use HasFactory;

    // Table name if it differs from default (which would be 'vouchers_unique_numbers')
    protected $table = 'vouchers_unique_number';

    // Primary key field
    protected $primaryKey = 'id_vouchers_unique_number';

    // Specify which fields can be mass-assigned
    protected $fillable = [
        'voucher_type',
        'voucher_number',
        'created_at'
    ];

    /**
     * Get the vouchers associated with this unique voucher number.
     */
    public function vouchers()
    {
        return $this->hasMany(Voucher::class, 'vouchers_unique_number_id');
    }

    // In Voucher model
    public function uniqueNumber()
    {
        return $this->belongsTo(VouchersUniqueNumber::class, 'vouchers_unique_number_id');
    }
}
