<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('business_id')->nullable();
            $table->string('po_number')->unique()->nullable();
            $table->unsignedBigInteger('supplier_id')->nullable();
            $table->date('order_date')->nullable();
            $table->decimal('custom_charges', 15, 2)->default(0)->nullable();
            $table->decimal('tax', 15, 2)->default(0)->nullable();
            $table->decimal('grand_total', 15, 2)->default(0)->nullable();
            $table->string('status')->default('pending')->nullable();
            $table->text('notes')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_orders');
    }
}
