<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseOrderDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_order_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('purchase_order_id');
            $table->unsignedBigInteger('pro_cate_main_id')->nullable();
            $table->unsignedBigInteger('pro_cate_parent_id')->nullable();
            $table->unsignedBigInteger('pro_cate_child_id')->nullable();
            $table->string('name')->nullable();
            $table->string('marka')->nullable();
            $table->integer('bori')->default(0)->nullable();
            $table->integer('weight')->default(0)->nullable();
            $table->decimal('rate', 15, 2)->default(0)->nullable();
            $table->decimal('amount', 15, 2)->default(0)->nullable();
            $table->text('description')->nullable()->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamps();

            // Foreign key
            $table->foreign('purchase_order_id')
                ->references('id')
                ->on('purchase_orders')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_order_details');
    }
}
