@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Products</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Products List
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped table-hover table-bordered">
                        <thead class="thead-dark">
                            <tr>
                                <th class="wd-5p">#</th>
                                {{-- <th class="wd-10p">Date</th> --}}
                                <th class="wd-10p">P Main Cate</th>
                                <th class="wd-10p">P Parent Cate</th>
                                <th class="wd-10p">P Child Cate</th>
                                <th class="wd-5p">Marka</th>
                                <th class="wd-10p">Truck No</th>
                                <th class="wd-10p">Available Bori</th>
                                <th class="wd-10p">Sold Bori</th>
                                <th class="wd-5p">Weight</th>
                                <th class="wd-5p">Rate</th>
                                <th class="wd-5p">Supplier</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $index = 1;
                            @endphp

                            @foreach ($products as $mainProduct)
                                @foreach ($mainProduct->subCategoriesParent as $parentCate)
                                    @foreach ($parentCate->subCategoriesChild as $childCate)
                                        @php
                                            // Fetch matching good receipt details for the current product combination
                                            $goodReceipt = $good_receipts_truck
                                                ->map(function ($truck) use ($mainProduct, $parentCate, $childCate) {
                                                    return $truck->goodReceipts
                                                        ->map(function ($receipt) use (
                                                            $mainProduct,
                                                            $parentCate,
                                                            $childCate,
                                                        ) {
                                                            return $receipt->goodReceiptDetails
                                                                ->where(
                                                                    'pro_cate_main_id',
                                                                    $mainProduct->id_pro_cate_main,
                                                                )
                                                                ->where(
                                                                    'pro_cate_parent_id',
                                                                    $parentCate->id_pro_sub_cat_parent,
                                                                )
                                                                ->where(
                                                                    'pro_cate_child_id',
                                                                    $childCate->id_pro_sub_cat_child,
                                                                )
                                                                ->first();
                                                        })
                                                        ->filter()
                                                        ->first();
                                                })
                                                ->filter()
                                                ->first();

                                            // Fetch matching sale details for the current product combination
                                            $saleDetail = $sales
                                                ->map(function ($sale) use ($mainProduct, $parentCate, $childCate) {
                                                    return $sale->salesItemsDetails
                                                        ->where('items_main_cate', $mainProduct->products_category_name)
                                                        ->where('items_parent_cate', $parentCate->name)
                                                        ->where('items_child_cate', $childCate->name)
                                                        ->first();
                                                })
                                                ->filter()
                                                ->first();

                                            // Set default values for bori and sold
                                            $overallBori = $goodReceipt ? $goodReceipt->bori : 0;
                                            $soldBori = $saleDetail ? $saleDetail->bori : 0;
                                            $remainingBori = $overallBori - $soldBori;
                                        @endphp

                                        <tr>
                                            <td>{{ $index++ }}</td>
                                            {{-- <td>{{ $mainProduct->created_at->format('d-m-Y') }}</td> --}}
                                            <td>{{ $mainProduct->products_category_name }}</td>
                                            <td>{{ $parentCate->name }}</td>
                                            <td>{{ $childCate->name }}</td>
                                            <td>{{ $goodReceipt ? $goodReceipt->marka : '' }}</td>
                                            <td>{{ $goodReceipt ? $goodReceipt->goodReceiptTruck->truck_no : '' }}</td>
                                            <td>{{ number_format($overallBori, 2) }}</td>
                                            <td>{{ number_format($soldBori, 2) }}</td>
                                            <td>{{ $saleDetail ? number_format($saleDetail->weight, 2) : '' }}</td>
                                            <td>{{ $saleDetail ? number_format($saleDetail->rate, 2) : '' }}</td>

                                            <td>
                                                {{ $goodReceipt && $goodReceipt->goodReceipt->supplier ? $goodReceipt->goodReceipt->supplier->supplier_name : '' }}
                                            </td>
                                        </tr>
                                    @endforeach
                                @endforeach
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-5p">#</th>
                                {{-- <th class="wd-10p">Date</th> --}}
                                <th class="wd-10p">P Main Cate</th>
                                <th class="wd-10p">P Parent Cate</th>
                                <th class="wd-10p">P Child Cate</th>
                                <th class="wd-5p">Marka</th>
                                <th class="wd-10p">Truck No</th>
                                <th class="wd-10p">Available Bori</th>
                                <th class="wd-10p">Sold Bori</th>
                                <th class="wd-5p">Weight</th>
                                <th class="wd-5p">Rate</th>
                                <th class="wd-5p">Supplier</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Product?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('GET')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(document).ready(function() {

            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });

            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false,
                    targets: 0
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;

                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('good_receipts/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
