<!DOCTYPE html>
<html>

<head>
    <title>Sales Invoice - Print</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }

        .container {
            width: 95%;
            margin: auto;
        }

        h1,
        h2,
        h3 {
            text-align: center;
            margin-bottom: 5px;
        }

        .sections-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .section {
            padding: 10px;
            margin-top: 12px;
            border-bottom: 2px dashed black;
            width: 48%;
            box-sizing: border-box;
            margin-bottom: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            padding: 6px;
            text-align: right;
        }

        .text-right {
            text-align: right;
        }

        .no-print {
            margin-top: 20px;
            display: block;
        }

        @media print {
            .no-print {
                display: none;
            }

            .section {
                width: 48%;
            }

            .sections-row {
                flex-wrap: wrap;
            }

            .page-break {
                page-break-after: always;
            }
        }

        .page-break {
            page-break-after: always;
        }
    </style>
</head>

<body>
    <div class="container">

        @foreach ($sales as $index => $sale)
            {{-- Start a new row every 2 sections --}}
            @if ($index % 2 == 0)
                <div class="sections-row">
            @endif

            <div class="section">
                <h2>{{ $sale->customer->customer_name_urdu }}</h2>
                <p style="text-align: right">Date: {{ $sale->date->format('d/m/y') }}</p>

                <table>
                    <thead>
                        <tr>
                            <th>قیمت</th>
                            <th>ریٹ</th>
                            <th>وزن</th>
                            <th>بوری</th>
                            <th>مال</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($sale->salesItemsDetails as $item)
                            <tr>
                                <td>{{ number_format((int) $item->amount, 0) }}</td>
                                <td>{{ number_format((int) $item->rate, 0) }}</td>
                                <td>{{ $item->weight }}</td>
                                <td>{{ $item->bori }}</td>
                                <td>{{ $item->productChildCate?->name_urdu }}</td>
                            </tr>
                        @endforeach

                        <tr>
                            <td colspan="5"></td>
                        </tr>
                        <tr>
                            <td colspan="5"></td>
                        </tr>

                        <tr>
                            <th>{{ $sale->total_amount }}</th>
                            <th>بنام</th>
                        </tr>
                        <tr>
                            <th>{{ number_format($sale->customerBalance(), 0) }}</th>
                            <th>سابِقہ بیلنس</th>
                        </tr>
                        <tr>
                            <th>{{ number_format(str_replace(',', '', $sale->customerBalance()) + str_replace(',', '', $sale->total_amount), 0) }}
                            </th>
                            <th>حالیہ بیلنس</th>
                        </tr>
                    </tbody>
                </table>
            </div>

            {{-- Close row after 2 sections --}}
            @if ($index % 2 == 1 || $loop->last)
    </div>
    @endif


    @if (($index + 1) % 6 == 0)
        <div class="page-break"></div>
    @endif
    @endforeach

    <button class="no-print" onclick="window.print()">Print</button>
    </div>
</body>

</html>
