@extends('layouts.master')

@push('css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Stock In Hand Report</h3>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div style="border:1px solid red; padding:10px; margin-bottom:20px; background-color:#fdd;">
                    <strong>Errors:</strong>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form id="filterForm" class="row" method="GET" action="{{ route('stockInHandRegister.report.print') }}">

                <div class="row">

                    <div class="col-md-3">
                        <div class="form-group mt-3">
                            <label for="date">From Date</label>
                            <input type="text" name="from_date" readonly id="from_date" class="form-control date"
                                value="{{ request('date') }}">
                        </div>
                    </div>
                     <div class="col-md-3">
                        <div class="form-group mt-3">
                            <label for="date">To Date</label>
                            <input type="text" name="to_date" readonly id="to_date" class="form-control date"
                                value="{{ request('date') }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mt-3">
                            <label>Select Supplier</label>
                            <select id="suppliers" name="suppliers[]" class="form-control select2" multiple >
                                @foreach ($suppliers as $supplier)
                                    <option value="{{ $supplier->id_supplier }}">{{ $supplier->supplier_name }}</option>
                                @endforeach
                            </select>
                            <button type="button" id="toggleSelectBtn" class="btn btn-primary btn-sm"
                                style="margin-top:10px;">
                                Select All
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row ">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="az-content-label" for="productMainCate">Main Category</label>
                            <select name="productMainCate" id="productMainCate" class="form-control"
                                onchange="checkForParentCate(this.value)">
                                <option value="">Select Main Category</option>
                                @foreach ($productCateMain as $key => $main)
                                    <option value="{{ $main->id_pro_cate_main }}">
                                        {{ $main->products_category_name }} |
                                        {{ $main->products_category_name_urdu }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        @error('productMainCate')
                            <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                        @enderror
                    </div>
                    <div class="col-md-4" id="productParentCatShow" >
                        <div class="form-group">
                            <label class="az-content-label" for="productParentCate">Parent Category</label>
                            <select name="productParentCate" id="productParentCate" class="form-control"
                                onchange="checkForChildCate(this.value)">
                                <option value="">Select Parent Category</option>
                            </select>
                        </div>
                        @error('productParentCate')
                            <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                        @enderror
                    </div>
                    <div class="col-md-4" id="productChildCatShow" >
                        <div class="form-group">
                            <label class="az-content-label" for="productChildCate">Child Category</label>
                            <select name="productChildCate" id="productChildCate" class="form-control">
                                <option value="">Select Child Category</option>
                            </select>
                        </div>
                        @error('productChildCate')
                            <span class="form-text text-danger"><strong>{{ $message }}</strong></span>
                        @enderror
                    </div>
                </div>

                <div class="row mt-5">
                    <div class="col-md-12 text-center">
                        <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i> Print
                            View</button>
                    </div>
                </div>
            </form>
            <hr />

        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $(function() {
            $(".date").datepicker({
                dateFormat: "yy-mm-dd"
            });

        });

        function checkForParentCate(productMainCateId) {
            $.ajax({
                url: '{{ route("check-cate-parent") }}',
                type: 'GET',
                data: {
                    productMainCateId: productMainCateId
                },
                success: function(response) {
                    if (response.productParentCate.length > 0) {
                        let options = '<option value="">Select Item</option>';
                        response.productParentCate.forEach(function(subParentCategory) {
                            options +=
                                `<option value="${subParentCategory.id_pro_sub_cat_parent}">${subParentCategory.name} | ${subParentCategory.name_urdu}</option>`;
                        });
                        $('#productParentCate').html(options);
                        $('#productParentCatShow').show();
                    } else {
                        // $('#productParentCatShow').hide();
                        // $('#productChildCatShow').hide();
                    }
                },
                error: function() {
                    alert('Error checking Product Parent Category!');
                }
            });
        }

        function checkForChildCate(productParentCateId) {
            $.ajax({
                url: '{{ route("check-cate-child") }}',
                type: 'GET',
                data: {
                    productParentCateId: productParentCateId
                },
                success: function(response) {
                    if (response.productChildCate.length > 0) {
                        let options = '<option value="">Select Item</option>';
                        response.productChildCate.forEach(function(subChildCategory) {
                            options +=
                                `<option value="${subChildCategory.id_pro_sub_cat_child}">${subChildCategory.name} | ${subChildCategory.name_urdu}</option>`;
                        });
                        $('#productChildCate').html(options);
                        $('#productChildCatShow').show();
                    } else {
                        // $('#productChildCatShow').hide();
                    }
                },
                error: function() {
                    alert('Error checking Product Child Category!');
                }
            });
        }
    </script>
    <script>
        $(document).ready(function() {


            $('.select2').select2();

            $(document).ready(function() {

                $('.select2').select2();

                $('#toggleSelectBtn').click(function() {

                    let totalOptions = $('#suppliers option').length;
                    let selectedCount = $('#suppliers').val() ? $('#suppliers').val().length : 0;


                    if (selectedCount === totalOptions) {

                        $('#suppliers').val(null).trigger('change');

                        $('#toggleSelectBtn')
                            .text('Select All')
                            .removeClass('btn-danger')
                            .addClass('btn-primary');

                    } else {

                        let allValues = [];

                        $('#suppliers option').each(function() {
                            let val = $(this).val();
                            if (val !== "") allValues.push(val);
                        });

                        $('#suppliers').val(allValues).trigger('change');

                        $('#toggleSelectBtn')
                            .text('Deselect All')
                            .removeClass('btn-primary')
                            .addClass('btn-danger');
                    }

                });

            });

        });
    </script>
@endpush
