<?php

namespace App\Http\Controllers;

use App\Employees;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Notifications;
use App\Role;
use App\User;
use App\roles;
use App\role_user;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;

class UsersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    // protected $role_id;
    // public function __construct()
    // {
    //     $this->middleware('auth');
    //            $this->middleware(function ($request, $next) {
    //                $this->role_id = Auth::user()->role_id;
    //             //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //             //    $slug_filter = preg_replace('/[0-9]+/', '', $request->path());
    //             $ex = explode('/',$request->path());
    //             if(count($ex)>=3){
    //                 $sliced = array_slice($ex, 0, -1);

    //             }else{
    //                 $sliced = $ex;
    //             }

    //             $string = implode("/", $sliced);
    //     //                 dd($string);
    //                if (checkConstructor($this->role_id, count($ex)>=3 ? $string.'/': $string) == 1) {
    //                    return $next($request);
    //                }else if(strpos($request->path(), 'store') !== false){
    //                    return $next($request);
    //                }else if(strpos($request->path(), 'update') !== false){
    //                    return $next($request);
    //                } else {
    //                    abort(404);
    //                }
    //            });
    // }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function index()
    {
        // $users = User::select('users.id', 'users.name', 'users.status', 'users.created_at', 'users.updated_at', DB::raw('roles.name as role_name'))
        //     //->join('branches','branches.branch_id','users.branch_id')
        //     ->join('role_user', 'role_user.user_id', 'users.id', 'left')
        //     ->join('roles', 'roles.id', 'users.role_id', 'left')->get()->toArray();
        //        echo '<pre>'; print_r($users);exit;
        $users = User::with('roles')->where('id', '!=', auth()->user()->id)->get();
        return view('Users.index')->with(compact('users'));
    }


    public function create()
    {
        $title = 'Users';
        $menu = 'Users';
        $submenu = 'create';
        $employees = Employees::all();

        $roles = roles::all();
        //        echo '<pre>'; print_r($roles);exit;
        return view('Users.create', compact('roles', 'employees', 'title', 'menu', 'submenu'));
    }

    // public function store(Request $request)
    // {

    //     $this->validate($request, [
    //         'name' => 'required',
    //         'email' => 'required|email|unique:users',
    //         'password' => 'required|string|min:8|confirmed'
    //     ]);


    //     //$this->validate($request, $validate);

    //     $user = new User(); // User::firstOrCreate(['name' => $request->name, 'email' => $request->email]);

    //     if ($request->password) {
    //         $user->password = Hash::make($request->password);
    //     }

    //     $user->name = $request->name;
    //     $user->business_id = 1;
    //     $user->email = $request->email;
    //     //$user->branch_id = $request->branch_id;
    //     $user->role_id = $request->role_id;
    //     //dd($user); exit;
    //     //$user->password = bcrypt($request->password);



    //     if ($user->save()) {
    //         $role_user = new role_user();
    //         $role_user->role_id = $request->role_id;
    //         $role_user->user_id = $user->id;
    //         $role_user->save();
    //         //$role = DB::table('role_user')->insert(['user_id' => $user->id, 'role_id' => $request->role_id]);//role id will come from Form input
    //         session()->flash('success', 'User has been added');
    //     } else {
    //         session()->flash('danger', 'User has not been added');
    //     }
    //     return redirect(url('users'));
    // }
    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'employee_id' => 'nullable|exists:employees,id|unique:employees,user_id',
            'password' => 'required|string|min:8|confirmed'
        ]);
        $user = new User();
        $user->name = $request->name;
        $user->role_id = $request->role_id;
        $user->business_id = 1;
        $user->email = $request->email;
        $user->employee_id = $request->employee_id;
        $user->password = Hash::make($request->password);



        if ($user->save()) {
            // Assign role using Spatie
            $role = Role::findOrFail($request->role_id);
            $user->assignRole($role->name);

            if ($request->employee_id) {
                $employee = Employees::where('id', $request->employee_id)->first();
                $employee->user_id = $user->id;
                $employee->save();
            }

            session()->flash('success', 'User has been added with the assigned role.');
        } else {
            session()->flash('danger', 'User has not been added.');
        }

        return redirect(url('users'));
    }



    public function edit($id)
    {
        $dec_id = \Crypt::decrypt($id);
        $user = User::find($dec_id);

        $roles = roles::all();
        $employees = Employees::all();


        //print_r($plot); exit;
        return view('Users.edit')->with(compact('user', 'roles', 'employees'));
    }

    public function update(Request $request, $id)
    {

        $dec_id = \Crypt::decrypt($id);
        $user = User::find($dec_id);

        $validator = [
            'name' => 'required',
            'employee_id' => 'nullable|exists:employees,id|unique:employees,user_id,' . $user->employee_id . ',id',
            'email' => 'required|email|unique:users,email,' . $dec_id . ',id'
        ];
        if ($request->password) {
            $validator['password'] = 'required|string|min:8|confirmed';
        }
        $this->validate($request, $validator);
        //$this->validate($request, $validate);


        if ($request->password) {
            $user->password = Hash::make($request->password);
        }

        $user->name = $request->name;
        $user->email = $request->email;
        $user->status = $request->status;
        $user->role_id = $request->role_id;
        $user->employee_id = $request->employee_id;


        if ($user->save()) {
            $roleName = Role::find($request->role_id)->name;
            $user->syncRoles($roleName);
            if ($request->employee_id) {
                $employee = Employees::where('id', $request->employee_id)->first();
                $employee->user_id = $user->id;
                $employee->save();
            }

            // $role = DB::table('role_user')->where('user_id', $dec_id)->update(['user_id' => $user->id, 'role_id' => $request->role_id]); //role id will come from Form input
            session()->flash('success', 'User has been updated');
        } else {
            session()->flash('danger', 'User has not been updated');
        }
        return redirect(url('users'));
    }

    public function profile_index()
    {
        return view('Users.profile');
    }
}
