<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SupplierAccount extends Model
{
    protected $table = 'suppliers_account';
    protected $primaryKey = 'id_suppliers_account';

    protected $fillable = [
        'suppliers_id',
        'account_name',
        'account_no',
        'debit',
        'credit',
        'balance',
        'status',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'suppliers_id');
    }
}
