<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Departments extends Authenticatable
{
    protected $table = 'departments';


    protected $fillable = [
        'name',
        'code',
        'description',
        'status',
        'created_by'
    ];

    // Department.php
public function employees()
{
    return $this->hasMany(Employees::class,'department_id','id');
}

// Employee.php
public function department()
{
    return $this->belongsTo(Departments::class);
}

public function attendances()
{
    return $this->hasMany(EmployeeAttendance::class);
}

// Attendance.php
public function employee()
{
    return $this->belongsTo(Employees::class);
}

}
