@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Employee</span>
    </div>
    <h2 class="az-content-title" style="display: inline"> Employees List <span>
            @can('Employees add')
                <a id="addbtn" href="{{ url('employee/create') }}" class="btn btn-az-primary" style="float: right">
                    <i class="fa-solid fa-plus"></i> Add Employee</a>
            @endcan
        </span></h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <table id="example2" class="table table-striped ">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Employee Name</th>
                            <th>Employee No</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>DOB</th>
                            <th>Joining Date</th>
                            <th>Department</th>
                            <th>Designation</th>
                            <th>Basic Salary</th>
                            <th>Status</th>
                            <th>Created By</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($employees as $key => $employee)
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td>{{ $employee->first_name }} {{ $employee->last_name ?? '' }}</td>
                                <td>{{ $employee->employee_no }}</td>
                                <td>{{ $employee->email ?? 'N/A' }}</td>
                                <td>{{ $employee->phone ?? 'N/A' }}</td>
                                <td>{{ $employee->dob ? $employee->dob->format('d-m-Y') : 'N/A' }}</td>
                                <td>{{ $employee->joining_date ? $employee->joining_date->format('d-m-Y') : 'N/A' }}</td>
                                <td>{{ optional($employee->department)->name ?? 'N/A' }}</td>
                                <td>{{ optional($employee->designation)->title ?? 'N/A' }}</td>
                                <td>{{ number_format($employee->basic_salary, 2) }}</td>
                                <td>
                                    @if ($employee->status == 'active')
                                        <span class="btn btn-rounded btn-success text-white">Active</span>
                                    @elseif($employee->status == 'inactive')
                                        <span class="btn btn-rounded btn-warning text-white">Inactive</span>
                                    @else
                                        <span class="btn btn-rounded btn-danger text-white">Terminated</span>
                                    @endif
                                </td>
                                <td>{{ optional($employee->user)->name ?? 'N/A' }}</td>
                                <td>{{ $employee->created_at?->format('d-m-Y') }}</td>
                                <td>
                                    @can('Employees edit')
                                        <a class="btn btn-primary shadow-base" title="Edit Employee"
                                            href="{{ route('employees.edit', ['id' => \Crypt::encrypt($employee->id)]) }}">
                                            <i class="text-white fa-regular fa-pen-to-square"></i>
                                            <span class="">Edit</span>
                                        </a>
                                    @endcan
                                    @can('Employees delete')
                                        <a class="btn btn-danger mt-2 shadow-base" data-toggle="modal"
                                            data-target="#deleteModal" data-id="{{ $employee->id }}">
                                            <i class=" fa-regular fa-trash-can"></i>
                                            <span class="">Remove</span>
                                        </a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>S.No</th>
                            <th>Employee Name</th>
                            <th>Employee No</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>DOB</th>
                            <th>Joining Date</th>
                            <th>Department</th>
                            <th>Designation</th>
                            <th>Basic Salary</th>
                            <th>Status</th>
                            <th>Created By</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <!-- Delete Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Employee?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        document.addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 'a') {
                event.preventDefault();
                document.getElementById('addbtn').click();
            }
        });

        $(document).ready(function() {
            $(function() {
                oTable = $('#example2').DataTable({
                    dom: 'Bfrtip',
                    buttons: [{
                            extend: 'csv',
                            text: 'CSV',
                            title: 'Employee List',
                            className: 'btn btn-default',
                            exportOptions: {
                                columns: 'th:not(:last-child)'
                            }
                        },
                        {
                            extend: 'excel',
                            text: 'Excel',
                            title: 'Employee List',
                            className: 'btn btn-default',
                            exportOptions: {
                                columns: 'th:not(:last-child)'
                            }
                        },
                        {
                            extend: 'pdf',
                            text: 'PDF',
                            title: 'Employee List',
                            className: 'btn btn-default',
                            exportOptions: {
                                columns: 'th:not(:last-child)'
                            }
                        },
                        {
                            extend: 'print',
                            text: 'Print',
                            title: 'Employee List',
                            className: 'btn btn-default',
                            exportOptions: {
                                columns: 'th:not(:last-child)'
                            }
                        }
                    ],
                    responsive: true
                });
            });


            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('employee/delete') }}/' + id;
                $(this).find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
