<!doctype html>
<html lang="ur" dir="rtl">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Invoice - B-Cheque</title>

    <style>
        body {
            margin: 0;
            padding: 0;
            background: #eee;
            font-family: 'Noto Nastaliq Urdu', 'Arial Unicode MS';
        }

        .page {
            width: 210mm;
            background: white;
            margin: 10px auto;
            padding: 10mm 12mm;
            box-shadow: 0 0 8px rgba(0, 0, 0, 0.25);
        }

        .header-wrapper {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .header-logo img {
            width: 140px;
        }

        .header-text {
            flex-grow: 1;
            text-align: right;
            line-height: 1.5;
            font-size: 22px;
            font-weight: bold;
        }

        .header-text .small {
            font-size: 14px;
            font-weight: normal;
        }

        .contact {
            text-align: right;
            font-size: 14px;
            line-height: 1.5;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            margin: 15px 0;
            border: 1px solid #777;
            border-radius: 6px;
            font-size: 16px;
        }

        .info-box {
            width: 48%;
            padding: 8px 10px;
            /* border: 1px solid #777; */
            border-radius: 6px;
            background: #fafafa;
        }

        .info-label {
            display: block;
            font-weight: bold;
            margin-bottom: 4px;
            border-bottom: 1px dashed #333;
            padding-bottom: 3px;
            text-align: right;
        }

        table td:nth-child(n+3),
        table th:nth-child(n+3) {
            border-left: 1px solid #333 !important;
            border-right: 1px solid #333 !important;
            border-top: none !important;
            border-bottom: none !important;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            font-size: 15px;
        }

        table th {
            background: #d7e6ef;
            border: 1px solid #333;
            padding: 6px;
        }

        .bg-highlight {
            background: #d7e6ef;
        }

        table td {
            border: 1px solid #333;
            padding: 6px;
            text-align: center;
        }

        .rounded {
            border-bottom-left-radius: 18px;
            border-bottom-right-radius: 18px;
        }

        .bottom-boxes {
            width: 260px;
            float: left;
            font-size: 15px;
            margin-top: 20px;
        }

        .signature {
            margin-top: 80px;
            display: flex;
            justify-content: flex-start;
        }

        .signature-line {
            width: 200px;
            border-top: 1px solid #000;
            padding-top: 6px;
            text-align: center;
        }

        .b-none {
            border: none !important;
        }


        @page {
            size: A4 portrait;
            margin: 0;
        }

        @media print {

            html,
            body {
                width: 210mm !important;
                height: 297mm !important;
                margin: 0 !important;
                padding: 0 !important;
                background: white !important;
                overflow: hidden !important;
            }

            .page {
                width: 200mm !important;
                min-height: 287mm !important;
                /* margin: 0 auto !important; */
                padding: 5mm 5mm !important;
                box-shadow: none !important;

                margin-top: 30px;
                transform: scale(1);
                transform-origin: top center;
            }

            tr,
            td,
            th,
            .info-row,
            .bottom-boxes,
            .signature {
                page-break-inside: avoid !important;
            }

            .bottom-boxes {
                float: left !important;
                position: relative !important;
                margin-top: 10px !important;
            }
        }
    </style>
</head>

<body>
    <div class="page">

        <!-- HEADER -->
        <div class="header-wrapper inner-wrap">

            <div class="header-text">
                چوہدری محمد دین محمد شریف اینڈ کو<br>
                <span class="small">الو پوہ — امپورٹر، ایکسپورٹر، کمیشن ایجنٹس<br>
                    نو اسٹریٹ مارکیٹ سپر ہائی وے کراچی</span>

                <div class="contact">
                    <span style="font-weight: 100;"> منڈی:</span>
                    35950017-021<br>
                    0333-2174848<br>
                    mdskarachi@hotmail.com
                </div>
            </div>



            <div class="header-logo">
                <img src="{{ asset('/img/MDS_LOGO.png') }}" />
            </div>
        </div>

        <!-- INFO -->
        <div class="info-row">
            <div class="info-box" style="width: 60%">
                <br>
                <span class="info-label ">تاریخ: &nbsp;&nbsp;<span style="font-weight: 100;">{{ $b_cheque->date->format('d/m/Y') }}</span></span>
                <br><br>

                <span class="info-label" > محترمی جناب:&nbsp;&nbsp;<span style="font-weight: 100;">{{ $b_cheque->supplier->supplier_name_urdu }}</span></span>
                {{-- {{ $b_cheque->supplier->supplier_name_urdu }}<br><br> --}}
                {{-- {{ $b_cheque->goodReceiptTruck->truck_no }} --}}
            </div>

            <div class="info-box" style="text-align:right;width: 40%">
                <br>
                <span class="info-label">حوالہ نمبر:<span style="font-weight: 100;">&nbsp;&nbsp;{{ $b_cheque->bilty_no }}</span></span>
                <br><br>
                <span class="info-label">گاڑی نمبر: <span style="font-weight: 100;">
                        &nbsp;&nbsp;{{ $b_cheque->goodReceiptTruck->truck_no }}</span></span>
                <br>
            </div>
        </div>

        {{-- <div class="info-row" style="margin-top:0;">
            <div class="info-box" style="width:100%; text-align:center;">
                <span class="info-label">حوالہ نمبر</span>
                MDS-24455
            </div>
        </div> --}}

        <!-- TABLE CONTENT -->
        @php
            $details = $b_cheque->details;
            $rows = collect([
                (object) ['item' => 'کرایہ محصول', 'value' => number_format($details->rent_recieve_amount, 0) ?? '-'],
                (object) ['item' => 'مزوری', 'value' => number_format($details->labour_amount, 0) ?? '-'],
                (object) ['item' => 'مارکیٹ فیس', 'value' => number_format($details->market_fees_amount, 0) ?? '-'],
                (object) ['item' => 'ڈاک خرج', 'value' => number_format($details->post_expense_amount, 0) ?? '-'],
                (object) [
                    'item' => 'خرجہ متفرقات',
                    'value' => number_format($details->miscellaneous_expense_amount, 0) ?? '-',
                ],
                (object) ['item' => 'نقد', 'value' => number_format($details->cash_amount, 0) ?? '-'],
                (object) ['item' => 'کمیشن', 'value' => number_format($details->commission_amount, 0) ?? '-'],
            ]);

            $maal = $b_cheque->items;
        @endphp

        <table>
            <tr style="border: 1px solid black;">
                <th>تفصیل خرج</th>
                <th>رقم</th>
                <th>مال</th>
                <th>بورے</th>
                <th>وزن</th>
                <th>بهاؤدر</th>
                <th>قیمت</th>
            </tr>
            @php
                $bori = 0;
                $weight = 0;
                $total_amount = 0;
            @endphp
            @foreach ($maal as $index => $m)
                @php
                    $bori += $m->bori;
                    $weight += $m->weight;
                    $total_amount += $m->amount;
                @endphp
                <tr>
                    <td class="bg-highlight">{{ $rows[$index]->item ?? '' }}</td>
                    <td>{{ $rows[$index]->value ?? '' }}</td>
                    <td>{{ $m->productChildCate->name_urdu }}</td>
                    <td>{{ $m->bori }}</td>
                    <td>{{ $m->weight }}</td>
                    <td>{{ number_format($m->rate, 0) }}</td>
                    <td>{{ number_format($m->amount, 0) }}</td>
                </tr>
            @endforeach

            @foreach ($rows->skip($maal->count()) as $item)
                <tr>
                    <td class="bg-highlight">{{ $item->item }}</td>
                    <td>{{ $item->value }}</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
            @endforeach

            <tr>
                <td class="rounded bg-highlight"><b>کل خرجہ</b></td>
                <td class="rounded"><b>{{ number_format($details->total_expanse_amount, 0) }}</b></td>
                <td class="rounded"></td>
                <td class="rounded"></td>
                <td class="rounded"></td>
                <td class="rounded"></td>
                <td class="rounded"></td>
            </tr>

            <tr>
                <td class="b-none"></td>
                <td class="b-none"></td>
                <td style="border:1px solid black !important;"></td>
                <td style="border:1px solid black !important;">{{ $bori }}</td>
                <td style="border:1px solid black !important;">{{ $weight }}</td>
                <td style="border:1px solid black !important;"></td>
                <td style="border:1px solid black !important;"></td>
            </tr>
        </table>

        <div class="bottom-boxes">
            <table style="width:100%; border-collapse:collapse; text-align:center;">
                <tr>
                    <th style="border:1px solid #333;">خام بکری</th>
                    <td style="border:1px solid #333;">{{ number_format($total_amount, 0) }}</td>
                </tr>
                <tr>
                    <th style="border:1px solid #333;">کل خرجہ</th>
                    <td style="border:1px solid #333;">{{ number_format($details->total_expanse_amount, 0) }}</td>
                </tr>
                <tr>
                    <th style="border:1px solid #333;">پختہ بکری</th>
                    <td style="border:1px solid #333;">
                        {{ number_format($total_amount - $details->total_expanse_amount, 0) }}</td>
                </tr>
            </table>
        </div>

        <div class="signature">
            <div class="signature-line">دستخط</div>
        </div>

    </div>
</body>

</html>
